var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { elements as dmn15elements, meta as dmn15meta, } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/ts-gen/meta";
import { XmlParserTsIdRandomizer } from "@kie-tools/xml-parser-ts/dist/idRandomizer";
import { buildXmlHref, parseXmlHref } from "../xml/xmlHrefs";
export function getNewDmnIdRandomizer() {
    return new XmlParserTsIdRandomizer({
        meta: dmn15meta,
        elements: dmn15elements,
        newIdGenerator: generateUuid,
        matchers: [tDmnElementReferenceIdRandomizerMatcher],
    });
}
export var tDmnElementReferenceIdRandomizerMatcher = function (_a) {
    var parentJson = _a.parentJson, metaTypeName = _a.metaTypeName, attr = _a.attr;
    if (metaTypeName === "DMN15__tDMNElementReference" && attr === "@_href") {
        var href_1 = parseXmlHref(parentJson[attr]);
        return [
            href_1.id,
            function (_a) {
                var newId = _a.newId;
                console.debug("ID RANDOMIZER: [anyURI] Updating id from ".concat(href_1.id, " to ").concat(newId, " @ (").concat(String(metaTypeName), ".").concat(String(attr), ": ").concat(parentJson[attr], ")"));
                parentJson[attr] = buildXmlHref(__assign(__assign({}, href_1), { id: newId }));
            },
        ];
    }
};
//# sourceMappingURL=dmnIdRandomizer.js.map