var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { FormSection } from "@patternfly/react-core/dist/js/components/Form";
import { NumberInput } from "@patternfly/react-core/dist/js/components/NumberInput";
import { Select, SelectOption, SelectVariant } from "@patternfly/react-core/dist/js/components/Select";
import { ToggleGroup, ToggleGroupItem } from "@patternfly/react-core/dist/js/components/ToggleGroup";
import { PencilAltIcon } from "@patternfly/react-icons/dist/js/icons/pencil-alt-icon";
import { UndoAltIcon } from "@patternfly/react-icons/dist/js/icons/undo-alt-icon";
import * as React from "react";
import { useCallback, useEffect, useMemo, useState } from "react";
import { useDmnEditor } from "../DmnEditorContext";
import { addOrGetDrd } from "../mutations/addOrGetDrd";
import { useInViewSelect } from "../responsiveness/useInViewSelect";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { ColorPicker } from "./ColorPicker";
import { PropertiesPanelHeader } from "./PropertiesPanelHeader";
import "./FontOptions.css";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
var WEBSAFE_FONTS_LIST = [
    "Arial",
    "Verdana",
    "Tahoma",
    "Trebuchet MS",
    "Times New Roman",
    "Georgia",
    "Garamond",
    "Courier New",
    "Brush Script MT",
];
var DEFAULT_FONT_COLOR = { "@_blue": 0, "@_green": 0, "@_red": 0 };
var DEFAULT_FONT_SIZE = 16;
var MAX_FONT_SIZE = 72;
var MIN_FONT_SIZE = 0;
var FontStyleToggleOptions;
(function (FontStyleToggleOptions) {
    FontStyleToggleOptions["BOLD"] = "bold";
    FontStyleToggleOptions["ITALIC"] = "italic";
    FontStyleToggleOptions["UNDERLINE"] = "underline";
    FontStyleToggleOptions["STRIKE_THROUGH"] = "strike-through";
    FontStyleToggleOptions["FONT_COLOR"] = "font-color";
})(FontStyleToggleOptions || (FontStyleToggleOptions = {}));
export function FontOptions(_a) {
    var startExpanded = _a.startExpanded, nodeIds = _a.nodeIds;
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var shapeStyles = useDmnEditorStore(function (s) {
        return nodeIds.map(function (nodeId) { var _a; return (_a = s.computed(s).indexedDrd().dmnShapesByHref.get(nodeId)) === null || _a === void 0 ? void 0 : _a["di:Style"]; });
    });
    var fontFamily = useMemo(function () { var _a; return (_a = shapeStyles[0]) === null || _a === void 0 ? void 0 : _a["@_fontFamily"]; }, [shapeStyles]);
    var isFontBold = useMemo(function () { var _a, _b; return (_b = (_a = shapeStyles[0]) === null || _a === void 0 ? void 0 : _a["@_fontBold"]) !== null && _b !== void 0 ? _b : false; }, [shapeStyles]);
    var isFontItalic = useMemo(function () { var _a, _b; return (_b = (_a = shapeStyles[0]) === null || _a === void 0 ? void 0 : _a["@_fontItalic"]) !== null && _b !== void 0 ? _b : false; }, [shapeStyles]);
    var isFontUnderline = useMemo(function () { var _a; return (_a = shapeStyles[0]) === null || _a === void 0 ? void 0 : _a["@_fontUnderline"]; }, [shapeStyles]);
    var isFontStrikeThrough = useMemo(function () { var _a, _b; return (_b = (_a = shapeStyles[0]) === null || _a === void 0 ? void 0 : _a["@_fontStrikeThrough"]) !== null && _b !== void 0 ? _b : false; }, [shapeStyles]);
    var fontSize = useMemo(function () { var _a, _b; return (_b = (_a = shapeStyles[0]) === null || _a === void 0 ? void 0 : _a["@_fontSize"]) !== null && _b !== void 0 ? _b : DEFAULT_FONT_SIZE; }, [shapeStyles]);
    var fontColor = useMemo(function () {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j;
        var b = ((_c = (_b = (_a = shapeStyles[0]) === null || _a === void 0 ? void 0 : _a["dmndi:FontColor"]) === null || _b === void 0 ? void 0 : _b["@_blue"]) !== null && _c !== void 0 ? _c : DEFAULT_FONT_COLOR["@_blue"]).toString(16);
        var g = ((_f = (_e = (_d = shapeStyles[0]) === null || _d === void 0 ? void 0 : _d["dmndi:FontColor"]) === null || _e === void 0 ? void 0 : _e["@_green"]) !== null && _f !== void 0 ? _f : DEFAULT_FONT_COLOR["@_green"]).toString(16);
        var r = ((_j = (_h = (_g = shapeStyles[0]) === null || _g === void 0 ? void 0 : _g["dmndi:FontColor"]) === null || _h === void 0 ? void 0 : _h["@_red"]) !== null && _j !== void 0 ? _j : DEFAULT_FONT_COLOR["@_red"]).toString(16);
        return "#".concat(r.length === 1 ? "0" + r : r).concat(g.length === 1 ? "0" + g : g).concat(b.length === 1 ? "0" + b : b);
    }, [shapeStyles]);
    var _b = __read(useState(startExpanded), 2), isStyleSectionExpanded = _b[0], setStyleSectionExpanded = _b[1];
    var setShapeStyles = useCallback(function (callback) {
        dmnEditorStoreApi.setState(function (s) {
            var e_1, _a;
            var _b;
            var diagramElements = addOrGetDrd({
                definitions: s.dmn.model.definitions,
                drdIndex: s.computed(s).getDrdIndex(),
            }).diagramElements;
            var shapes = nodeIds.map(function (nodeId) {
                var shape = s.computed(s).indexedDrd().dmnShapesByHref.get(nodeId);
                if (!shape) {
                    throw new Error("DMN Shape for '".concat(nodeId, "' does not exist."));
                }
                return diagramElements[shape.index];
            });
            try {
                for (var shapes_1 = __values(shapes), shapes_1_1 = shapes_1.next(); !shapes_1_1.done; shapes_1_1 = shapes_1.next()) {
                    var shape = shapes_1_1.value;
                    (_b = shape["di:Style"]) !== null && _b !== void 0 ? _b : (shape["di:Style"] = { "@_id": generateUuid(), __$$element: "dmndi:DMNStyle" });
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (shapes_1_1 && !shapes_1_1.done && (_a = shapes_1.return)) _a.call(shapes_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            callback(shapes, s);
        });
    }, [dmnEditorStoreApi, nodeIds]);
    var dmnEditorRootElementRef = useDmnEditor().dmnEditorRootElementRef;
    var toggleRef = React.useRef(null);
    var inViewTimezoneSelect = useInViewSelect(dmnEditorRootElementRef, toggleRef);
    var _c = __read(useState(false), 2), isFontFamilySelectOpen = _c[0], setFontFamilySelectOpen = _c[1];
    var onSelectFont = useCallback(function (e, value, isPlaceholder) {
        if (isPlaceholder) {
            setShapeStyles(function (shapes) {
                shapes.forEach(function (shape, i, shapes) {
                    var _a;
                    var _b;
                    (_a = (_b = shape["di:Style"])["@_fontFamily"]) !== null && _a !== void 0 ? _a : (_b["@_fontFamily"] = undefined);
                });
            });
        }
        else {
            setShapeStyles(function (shapes) {
                shapes.forEach(function (shape, i, shapes) {
                    shape["di:Style"]["@_fontFamily"] = value;
                });
            });
        }
    }, [setShapeStyles]);
    var validateFontSize = useCallback(function (value) {
        if (value === undefined) {
            return DEFAULT_FONT_SIZE;
        }
        if (value >= MAX_FONT_SIZE) {
            return MAX_FONT_SIZE;
        }
        if (value <= MIN_FONT_SIZE) {
            return MIN_FONT_SIZE;
        }
        return value;
    }, []);
    var onMinus = useCallback(function () {
        setShapeStyles(function (shapes) {
            shapes.forEach(function (shape) {
                var _a, _b;
                shape["di:Style"]["@_fontSize"] = validateFontSize(((_b = (_a = shape["di:Style"]) === null || _a === void 0 ? void 0 : _a["@_fontSize"]) !== null && _b !== void 0 ? _b : DEFAULT_FONT_SIZE) - 1);
            });
        });
    }, [setShapeStyles, validateFontSize]);
    var onChange = useCallback(function (event) {
        setShapeStyles(function (shapes) {
            shapes.forEach(function (shape) {
                shape["di:Style"]["@_fontSize"] = +event.target.value;
            });
        });
    }, [setShapeStyles]);
    var onPlus = useCallback(function () {
        setShapeStyles(function (shapes) {
            shapes.forEach(function (shape) {
                var _a, _b;
                shape["di:Style"]["@_fontSize"] = validateFontSize(((_b = (_a = shape["di:Style"]) === null || _a === void 0 ? void 0 : _a["@_fontSize"]) !== null && _b !== void 0 ? _b : DEFAULT_FONT_SIZE) + 1);
            });
        });
    }, [setShapeStyles, validateFontSize]);
    var onChangeBold = useCallback(function () {
        setShapeStyles(function (shapes) {
            shapes.forEach(function (shape) {
                var _a, _b;
                shape["di:Style"]["@_fontBold"] = (_b = !((_a = shape === null || shape === void 0 ? void 0 : shape["di:Style"]) === null || _a === void 0 ? void 0 : _a["@_fontBold"])) !== null && _b !== void 0 ? _b : true;
            });
        });
    }, [setShapeStyles]);
    var onChangeItalic = useCallback(function () {
        setShapeStyles(function (shapes) {
            shapes.forEach(function (shape) {
                var _a, _b;
                shape["di:Style"]["@_fontItalic"] = (_b = !((_a = shape === null || shape === void 0 ? void 0 : shape["di:Style"]) === null || _a === void 0 ? void 0 : _a["@_fontItalic"])) !== null && _b !== void 0 ? _b : true;
            });
        });
    }, [setShapeStyles]);
    var onChangeUnderline = useCallback(function () {
        setShapeStyles(function (shapes) {
            shapes.forEach(function (shape) {
                var _a, _b;
                shape["di:Style"]["@_fontUnderline"] = (_b = !((_a = shape === null || shape === void 0 ? void 0 : shape["di:Style"]) === null || _a === void 0 ? void 0 : _a["@_fontUnderline"])) !== null && _b !== void 0 ? _b : true;
            });
        });
    }, [setShapeStyles]);
    var onChangeStrikeThrough = useCallback(function () {
        setShapeStyles(function (shapes) {
            shapes.forEach(function (shape) {
                var _a, _b;
                shape["di:Style"]["@_fontStrikeThrough"] = (_b = !((_a = shape === null || shape === void 0 ? void 0 : shape["di:Style"]) === null || _a === void 0 ? void 0 : _a["@_fontStrikeThrough"])) !== null && _b !== void 0 ? _b : true;
            });
        });
    }, [setShapeStyles]);
    var colorPickerRef = React.useRef(null);
    var _d = __read(useState(), 2), temporaryFontColor = _d[0], setTemporaryFontColor = _d[1];
    var onChangeColor = useCallback(function (newColor) {
        setTemporaryFontColor(newColor.replace("#", ""));
        setShapeStyles(function (shapes, state) {
            state.diagram.isEditingStyle = true;
        });
    }, [setShapeStyles]);
    useEffect(function () {
        var timeout = setTimeout(function () {
            if (!temporaryFontColor) {
                return;
            }
            setTemporaryFontColor(undefined);
            setShapeStyles(function (shapes, state) {
                shapes.forEach(function (shape) {
                    var _a;
                    var _b;
                    state.diagram.isEditingStyle = false;
                    (_a = (_b = shape["di:Style"])["dmndi:FontColor"]) !== null && _a !== void 0 ? _a : (_b["dmndi:FontColor"] = __assign({}, DEFAULT_FONT_COLOR));
                    shape["di:Style"]["dmndi:FontColor"]["@_red"] = parseInt(temporaryFontColor.slice(0, 2), 16);
                    shape["di:Style"]["dmndi:FontColor"]["@_green"] = parseInt(temporaryFontColor.slice(2, 4), 16);
                    shape["di:Style"]["dmndi:FontColor"]["@_blue"] = parseInt(temporaryFontColor.slice(4, 6), 16);
                });
            });
        }, 0);
        return function () {
            clearTimeout(timeout);
        };
    }, [setShapeStyles, temporaryFontColor]);
    var onReset = useCallback(function () {
        setShapeStyles(function (shapes, state) {
            state.diagram.isEditingStyle = false;
            shapes.forEach(function (shape) {
                shape["di:Style"]["@_fontBold"] = undefined;
                shape["di:Style"]["@_fontItalic"] = undefined;
                shape["di:Style"]["@_fontUnderline"] = undefined;
                shape["di:Style"]["@_fontStrikeThrough"] = undefined;
                shape["di:Style"]["@_fontSize"] = undefined;
                shape["di:Style"]["@_fontFamily"] = undefined;
                shape["di:Style"]["dmndi:FontColor"] = __assign({}, DEFAULT_FONT_COLOR);
            });
        });
    }, [setShapeStyles]);
    return (_jsxs(_Fragment, { children: [_jsx(PropertiesPanelHeader, { icon: _jsx(PencilAltIcon, { width: 16, height: 36, style: { marginLeft: "12px" } }), expands: true, fixed: false, isSectionExpanded: isStyleSectionExpanded, toogleSectionExpanded: function () { return setStyleSectionExpanded(function (prev) { return !prev; }); }, title: "Font", action: _jsx(Button, __assign({ variant: ButtonVariant.plain, onClick: function () { return onReset(); }, style: { paddingBottom: 0, paddingTop: 0 }, title: "Reset font" }, { children: _jsx(UndoAltIcon, {}) })) }), isStyleSectionExpanded && (_jsx(FormSection, __assign({ style: { paddingLeft: "20px", marginTop: "0px" } }, { children: _jsxs("div", __assign({ style: { display: "flex", flexDirection: "column" } }, { children: [_jsxs("div", __assign({ className: "kie-dmn-editor--font-options-toggle-group" }, { children: [_jsx(NumberInput, { "aria-label": "Font size", className: "kie-dmn-editor--font-options-toggle-group-item-number-input", value: fontSize, isDisabled: false, widthChars: 2, onMinus: onMinus, onChange: onChange, onPlus: onPlus, inputName: "Font size", inputAriaLabel: "Font size", minusBtnAriaLabel: "minus", plusBtnAriaLabel: "plus" }), _jsxs(ToggleGroup, __assign({ areAllGroupsDisabled: false, "aria-label": "Default with multiple selectable" }, { children: [_jsx(ToggleGroupItem, { "aria-label": "Toggle font bold", className: "kie-dmn-editor--font-options-toggle-group-item", text: _jsx("div", { children: _jsx("b", { children: "B" }) }), buttonId: FontStyleToggleOptions.BOLD, isSelected: isFontBold, onChange: onChangeBold }, FontStyleToggleOptions.BOLD), _jsx(ToggleGroupItem, { "aria-label": "Toggle font italic", className: "kie-dmn-editor--font-options-toggle-group-item-italic", text: _jsx("div", { children: _jsx("i", __assign({ style: { fontFamily: "serif" } }, { children: "I" })) }), buttonId: FontStyleToggleOptions.ITALIC, isSelected: isFontItalic, onChange: onChangeItalic }, FontStyleToggleOptions.ITALIC), _jsx(ToggleGroupItem, { className: "kie-dmn-editor--font-options-toggle-group-item", text: _jsx("div", { children: _jsx("u", { children: "U" }) }), "aria-label": "Toggle font underline", buttonId: FontStyleToggleOptions.UNDERLINE, isSelected: isFontUnderline, onChange: onChangeUnderline }, FontStyleToggleOptions.UNDERLINE), _jsx(ToggleGroupItem, { className: "kie-dmn-editor--font-options-toggle-group-item", text: _jsx("div", { children: _jsx("p", __assign({ style: { textDecoration: "line-through" } }, { children: "S" })) }), "aria-label": "Toggle font strike through", buttonId: FontStyleToggleOptions.STRIKE_THROUGH, isSelected: isFontStrikeThrough, onChange: onChangeStrikeThrough }, FontStyleToggleOptions.STRIKE_THROUGH), _jsx(ToggleGroupItem, { className: "kie-dmn-editor--font-options-toggle-group-item-color-picker", "aria-label": "Font color", buttonId: FontStyleToggleOptions.FONT_COLOR, onClick: function () { var _a; return (_a = colorPickerRef.current) === null || _a === void 0 ? void 0 : _a.click(); }, text: _jsx(ColorPicker, { name: "font", icon: _jsx("p", { children: "A" }), colorPickerRef: colorPickerRef, color: fontColor, onChange: onChangeColor }) }, FontStyleToggleOptions.FONT_COLOR)] }))] })), _jsx("br", {}), _jsx("div", __assign({ "data-testid": "kie-tools--dmn-editor--properties-panel-node-font-style" }, { children: _jsx(Select, __assign({ toggleRef: toggleRef, variant: SelectVariant.single, "aria-label": "Select font style", isOpen: isFontFamilySelectOpen, onSelect: onSelectFont, onToggle: function () { return setFontFamilySelectOpen(function (prev) { return !prev; }); }, selections: fontFamily !== null && fontFamily !== void 0 ? fontFamily : "", isDisabled: false, maxHeight: inViewTimezoneSelect.maxHeight, direction: inViewTimezoneSelect.direction }, { children: WEBSAFE_FONTS_LIST.map(function (fontName, index) { return (_jsx(SelectOption, { value: fontName, style: { fontFamily: fontName } }, index)); }) })) }))] })) })))] }));
}
//# sourceMappingURL=FontOptions.js.map