"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FsUnloadManager = void 0;
var useImperativePromiseHandler_1 = require("@kie-tools-core/react-hooks/dist/useImperativePromiseHandler");
var FsUnloadManager = (function () {
    function FsUnloadManager(fsCache, readWriteFsUsageCounter, readonlyFsUsageCounter, fsFlushManager) {
        this.fsCache = fsCache;
        this.readWriteFsUsageCounter = readWriteFsUsageCounter;
        this.readonlyFsUsageCounter = readonlyFsUsageCounter;
        this.fsFlushManager = fsFlushManager;
        this.ongoingUnloads = new Map();
    }
    FsUnloadManager.prototype.makeSpaceForOrWaitUnloadOf = function (fsMountPoint) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        if (!this.fsCache.hasSpaceFor(fsMountPoint)) {
                            this.makeSpaceFor(fsMountPoint);
                        }
                        else {
                            console.debug("No need to make space for ".concat(fsMountPoint, "."));
                        }
                        return [4, ((_a = this.ongoingUnloads.get(fsMountPoint)) === null || _a === void 0 ? void 0 : _a.promise)];
                    case 1:
                        _b.sent();
                        return [2];
                }
            });
        });
    };
    FsUnloadManager.prototype.unloadFsIfMarkedAndNotInUse = function (fsMountPoint) {
        var _this = this;
        var unloadPromiseHandle = this.ongoingUnloads.get(fsMountPoint);
        if (!unloadPromiseHandle) {
            return { didTriggerUnload: false };
        }
        if (this.readWriteFsUsageCounter.isInUse(fsMountPoint) || this.readonlyFsUsageCounter.isInUse(fsMountPoint)) {
            return { didTriggerUnload: false };
        }
        var flushArgs = { executeEvenIfNotScheduled: !this.readWriteFsUsageCounter.isInUse(fsMountPoint) };
        setTimeout(function () { return _this.flushAndUnloadFs(fsMountPoint, unloadPromiseHandle, flushArgs); }, 0);
        return { didTriggerUnload: true };
    };
    FsUnloadManager.prototype.makeSpaceFor = function (fsMountPoint) {
        var _this = this;
        var fsMountPointToUnload = this.fsCache.getLastRecentlyUsed();
        if (this.ongoingUnloads.has(fsMountPointToUnload)) {
            return;
        }
        console.debug("Making space for ".concat(fsMountPoint, " by unloading ").concat(fsMountPointToUnload, "."));
        var _a = (0, useImperativePromiseHandler_1.imperativePromiseHandle)(), promise = _a.promise, resolve = _a.resolve, reject = _a.reject;
        var unloadPromiseHandle = {
            promise: promise.finally(function () { return _this.ongoingUnloads.delete(fsMountPointToUnload); }),
            resolve: resolve,
            reject: reject,
        };
        this.ongoingUnloads.set(fsMountPointToUnload, unloadPromiseHandle);
        this.unloadFsIfMarkedAndNotInUse(fsMountPointToUnload);
    };
    FsUnloadManager.prototype.flushAndUnloadFs = function (fsMountPoint, unloadPromiseHandle, flushArgs) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.fsFlushManager.expediteFlush(this.fsCache, fsMountPoint, flushArgs)];
                    case 1:
                        _a.sent();
                        this.fsCache.unloadFs(fsMountPoint);
                        unloadPromiseHandle.resolve();
                        return [2];
                }
            });
        });
    };
    return FsUnloadManager;
}());
exports.FsUnloadManager = FsUnloadManager;
//# sourceMappingURL=FsUnloadManager.js.map