import { WorkspaceDescriptor } from "../worker/api/WorkspaceDescriptor";
import { StorageFile, StorageService } from "./StorageService";
import { WorkspaceDescriptorService } from "./WorkspaceDescriptorService";
import { BroadcasterDispatch } from "./FsService";
import { WorkspaceOrigin } from "../worker/api/WorkspaceOrigin";
import { WorkspaceWorkerFileDescriptor } from "../worker/api/WorkspaceWorkerFileDescriptor";
import { WorkspaceWorkerFile } from "../worker/api/WorkspaceWorkerFile";
import { KieSandboxWorkspacesFs } from "./KieSandboxWorkspaceFs";
import { WorkspaceDescriptorFsService } from "./WorkspaceDescriptorFsService";
import { WorkspaceFsService } from "./WorkspaceFsService";
import { FsSchema } from "./FsCache";
export declare class WorkspaceService {
    readonly storageService: StorageService;
    private readonly descriptorsFsService;
    private readonly workspaceDescriptorService;
    private readonly fsService;
    constructor(storageService: StorageService, descriptorsFsService: WorkspaceDescriptorFsService, workspaceDescriptorService: WorkspaceDescriptorService, fsService: WorkspaceFsService);
    create(args: {
        storeFiles: (fs: KieSandboxWorkspacesFs, schema: FsSchema, workspace: WorkspaceDescriptor) => Promise<WorkspaceWorkerFileDescriptor[]>;
        origin: WorkspaceOrigin;
        preferredName?: string;
        gitAuthSessionId: string | undefined;
        gitInsecurelyDisableTlsCertificateValidation?: boolean;
    }): Promise<{
        workspace: WorkspaceDescriptor;
        files: WorkspaceWorkerFileDescriptor[];
    }>;
    getFilteredWorkspaceFileDescriptors(schema: FsSchema, workspaceId: string, globPattern?: string): Promise<WorkspaceWorkerFileDescriptor[]>;
    delete(workspaceId: string): Promise<void>;
    rename(workspaceId: string, newName: string): Promise<void>;
    prepareZip(fs: KieSandboxWorkspacesFs, schema: FsSchema, workspaceId: string, onlyExtensions?: string[], globPattern?: string): Promise<Blob>;
    createOrOverwriteFile(fs: KieSandboxWorkspacesFs, file: WorkspaceWorkerFile, broadcaster: BroadcasterDispatch): Promise<void>;
    getFile(args: {
        fs: KieSandboxWorkspacesFs;
        workspaceId: string;
        relativePath: string;
    }): Promise<WorkspaceWorkerFile | undefined>;
    updateFile(fs: KieSandboxWorkspacesFs, wwfd: WorkspaceWorkerFileDescriptor, getNewContents: () => Promise<string>, broadcaster: BroadcasterDispatch): Promise<void>;
    deleteFile(fs: KieSandboxWorkspacesFs, wwfd: WorkspaceWorkerFileDescriptor, broadcaster: BroadcasterDispatch): Promise<void>;
    renameFile(args: {
        fs: KieSandboxWorkspacesFs;
        wwfd: WorkspaceWorkerFileDescriptor;
        newFileNameWithoutExtension: string;
        broadcaster: BroadcasterDispatch;
    }): Promise<WorkspaceWorkerFileDescriptor>;
    moveFile(args: {
        fs: KieSandboxWorkspacesFs;
        wwfd: WorkspaceWorkerFileDescriptor;
        newDirPath: string;
        broadcaster: BroadcasterDispatch;
    }): Promise<WorkspaceWorkerFile>;
    existsFile(args: {
        fs: KieSandboxWorkspacesFs;
        workspaceId: string;
        relativePath: string;
    }): Promise<boolean>;
    getAbsolutePath(args: {
        workspaceId: string;
        relativePath?: string;
    }): string;
    toWorkspaceFile(workspaceId: string, storageFile: StorageFile): Promise<WorkspaceWorkerFile>;
    private toStorageFile;
    private toExistingStorageFile;
    getUniqueFileIdentifier(args: {
        workspaceId: string;
        relativePath: string;
    }): string;
}
//# sourceMappingURL=WorkspaceService.d.ts.map