"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var React = require("react");
var react_1 = require("react");
var react_sortable_hoc_1 = require("react-sortable-hoc");
var Button_1 = require("@patternfly/react-core/dist/js/components/Button");
var Text_1 = require("@patternfly/react-core/dist/js/components/Text");
var TextInput_1 = require("@patternfly/react-core/dist/js/components/TextInput");
var Flex_1 = require("@patternfly/react-core/dist/js/layouts/Flex");
var Stack_1 = require("@patternfly/react-core/dist/js/layouts/Stack");
var grip_vertical_icon_1 = require("@patternfly/react-icons/dist/js/icons/grip-vertical-icon");
var trash_icon_1 = require("@patternfly/react-icons/dist/js/icons/trash-icon");
var validation_1 = require("../../../validation");
var paths_1 = require("../../../paths");
require("./ConstraintsEnumEdit.scss");
var ConstraintsEnumEdit = function (props) {
    var dataFieldIndex = props.dataFieldIndex, enumerations = props.enumerations, onAdd = props.onAdd, onChange = props.onChange, onDelete = props.onDelete, onSort = props.onSort;
    var _a = __read((0, react_1.useState)(enumerations), 2), enums = _a[0], setEnums = _a[1];
    var _b = __read((0, react_1.useState)(), 2), addedEnum = _b[0], setAddedEnum = _b[1];
    var handleChange = function (value, index) {
        onChange(value, index);
    };
    var handleDelete = function (index) {
        onDelete(index);
    };
    var addOne = function () {
        onAdd();
        setAddedEnum(enums.length);
    };
    var handleTab = function () {
        console.log("tab detected");
    };
    var onSortEnd = function (_a) {
        var oldIndex = _a.oldIndex, newIndex = _a.newIndex;
        onSort(oldIndex, newIndex);
    };
    (0, react_1.useEffect)(function () {
        setEnums(enumerations);
    }, [enumerations]);
    return ((0, jsx_runtime_1.jsx)(EnumConstraintsContext.Provider, __assign({ value: {
            addedEnum: addedEnum,
            updateAddedEnum: function (position) {
                setAddedEnum(position);
            },
            dataFieldIndex: dataFieldIndex,
        } }, { children: (0, jsx_runtime_1.jsx)("section", __assign({ className: "constraints-enum" }, { children: (0, jsx_runtime_1.jsxs)(Stack_1.Stack, __assign({ hasGutter: true }, { children: [(0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsx)(Text_1.TextContent, { children: (0, jsx_runtime_1.jsx)(Text_1.Text, __assign({ component: Text_1.TextVariants.small }, { children: "Add constraints values to limit and define valid inputs for the data type." })) }) }), (0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsx)(EnumsList, { items: enums, onUpdate: handleChange, onTab: handleTab, onDelete: handleDelete, onSortEnd: onSortEnd, lockAxis: "y", distance: 10 }) }), (0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ variant: Button_1.ButtonVariant.secondary, onClick: addOne, ouiaId: "add-another-value" }, { children: "Add another value" })) })] })) })) })));
};
exports.default = ConstraintsEnumEdit;
var EnumsList = (0, react_sortable_hoc_1.SortableContainer)(function (_a) {
    var items = _a.items, onUpdate = _a.onUpdate, onTab = _a.onTab, onDelete = _a.onDelete;
    return ((0, jsx_runtime_1.jsx)("ul", __assign({ className: "constraints-enum__list", "aria-label": "Compact data list example" }, { children: items.map(function (item, index) { return ((0, jsx_runtime_1.jsx)(EnumItem, { enumValue: item, index: index, position: index, onUpdate: onUpdate, onTab: onTab, onDelete: onDelete, enumsCount: items.length, disabled: items.length === 1 }, index + item)); }) })));
});
var EnumItem = (0, react_sortable_hoc_1.SortableElement)(function (_a) {
    var enumValue = _a.enumValue, enumsCount = _a.enumsCount, position = _a.position, onUpdate = _a.onUpdate, onTab = _a.onTab, onDelete = _a.onDelete;
    var _b = __read((0, react_1.useState)(enumValue), 2), enumeration = _b[0], setEnumeration = _b[1];
    var _c = (0, react_1.useContext)(EnumConstraintsContext), dataFieldIndex = _c.dataFieldIndex, addedEnum = _c.addedEnum, updateAddedEnum = _c.updateAddedEnum;
    var handleChange = function (value) {
        setEnumeration(value);
    };
    var handleSave = function () {
        onUpdate(enumeration, position);
    };
    var handleDelete = function () {
        onDelete(position);
    };
    var handleTabNavigation = function (event) {
        if (event.key === "Tab") {
            onTab();
        }
    };
    var validationRegistry = (0, validation_1.useValidationRegistry)().validationRegistry;
    var validations = (0, react_1.useRef)(validationRegistry.get((0, paths_1.Builder)().forDataDictionary().forDataField(dataFieldIndex).forValue(position).build()));
    (0, react_1.useEffect)(function () {
        validations.current = validationRegistry.get((0, paths_1.Builder)().forDataDictionary().forDataField(dataFieldIndex).forValue(position).build());
    }, [position, enumValue]);
    var enumRef = (0, react_1.useRef)(null);
    (0, react_1.useEffect)(function () {
        if (enumRef.current && addedEnum === position) {
            var container = document.querySelector(".data-dictionary__properties-edit__form .constraints__form");
            container === null || container === void 0 ? void 0 : container.scroll({ top: container === null || container === void 0 ? void 0 : container.scrollHeight, behavior: "smooth" });
            updateAddedEnum(undefined);
        }
    }, [addedEnum, enumRef.current, position]);
    return ((0, jsx_runtime_1.jsx)("li", __assign({ className: "constraints-enum__item ".concat(enumsCount === 1 ? "constraints-enum__item--sort-disabled" : ""), tabIndex: 20 + position, ref: enumRef, "data-ouia-component-id": "val-".concat(position) }, { children: (0, jsx_runtime_1.jsxs)(Flex_1.Flex, { children: [(0, jsx_runtime_1.jsx)(Flex_1.FlexItem, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ variant: "plain", "aria-label": "Drag to sort", component: "span", isDisabled: enumsCount === 1, ouiaId: "drag-it" }, { children: (0, jsx_runtime_1.jsx)(grip_vertical_icon_1.GripVerticalIcon, {}) })) }), (0, jsx_runtime_1.jsx)(Flex_1.FlexItem, { children: (0, jsx_runtime_1.jsx)(TextInput_1.TextInput, { className: "constraints-enum__field", type: "text", id: "enum-value-".concat(position), name: "enum-value-".concat(position), placeholder: "Please enter a value", value: enumeration, onChange: handleChange, onBlur: handleSave, onKeyDown: handleTabNavigation, autoComplete: "off", validated: validations.current.length > 0 ? "warning" : "default", "data-ouia-component-type": "value-name" }) }), (0, jsx_runtime_1.jsx)(Flex_1.FlexItem, __assign({ align: { default: "alignRight" } }, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ variant: Button_1.ButtonVariant.plain, onClick: handleDelete, isDisabled: enumsCount === 1, ouiaId: "delete-item" }, { children: (0, jsx_runtime_1.jsx)(trash_icon_1.TrashIcon, {}) })) }))] }) })));
});
var EnumConstraintsContext = React.createContext({
    addedEnum: undefined,
    updateAddedEnum: function () { return null; },
    dataFieldIndex: undefined,
});
//# sourceMappingURL=ConstraintsEnumEdit.js.map