"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useBatchDispatch = void 0;
var react_redux_1 = require("react-redux");
var reducers_1 = require("../reducers");
var useBatchDispatch = function (service, getCurrentState) {
    var dispatch = (0, react_redux_1.useDispatch)();
    return function (action) {
        var result = dispatch(action);
        dispatch({
            type: reducers_1.Actions.Refresh,
            payload: {
                pmml: service.commit(getCurrentState()),
            },
        });
        return result;
    };
};
exports.useBatchDispatch = useBatchDispatch;
//# sourceMappingURL=BatchDispatchHook.js.map