"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataDictionaryReducer = void 0;
var Actions_1 = require("./Actions");
var validation_1 = require("../validation");
var paths_1 = require("../paths");
var DataDictionaryReducer = function (historyService, validationRegistry) {
    return function (state, action) {
        switch (action.type) {
            case Actions_1.Actions.AddDataDictionaryField:
                historyService.batch(state, (0, paths_1.Builder)().forDataDictionary().build(), function (draft) {
                    draft.DataField.push({
                        name: action.payload.name,
                        dataType: action.payload.type,
                        optype: action.payload.optype,
                    });
                });
                break;
            case Actions_1.Actions.DeleteDataDictionaryField:
                historyService.batch(state, (0, paths_1.Builder)().forDataDictionary().build(), function (draft) {
                    var index = action.payload.index;
                    if (index >= 0 && index < draft.DataField.length) {
                        draft.DataField.splice(index, 1);
                    }
                }, function (pmml) {
                    validationRegistry.clear((0, paths_1.Builder)().forDataDictionary().build());
                    (0, validation_1.validateDataFields)(pmml.DataDictionary.DataField, validationRegistry);
                });
                break;
            case Actions_1.Actions.ReorderDataDictionaryFields:
                historyService.batch(state, (0, paths_1.Builder)().forDataDictionary().build(), function (draft) {
                    var _a = __read(draft.DataField.splice(action.payload.oldIndex, 1), 1), removed = _a[0];
                    draft.DataField.splice(action.payload.newIndex, 0, removed);
                }, function (pmml) {
                    validationRegistry.clear((0, paths_1.Builder)().forDataDictionary().build());
                    (0, validation_1.validateDataFields)(pmml.DataDictionary.DataField, validationRegistry);
                });
                break;
            case Actions_1.Actions.AddBatchDataDictionaryFields:
                historyService.batch(state, (0, paths_1.Builder)().forDataDictionary().build(), function (draft) {
                    action.payload.dataDictionaryFields.forEach(function (name) {
                        draft.DataField.push({
                            name: name,
                            dataType: "string",
                            optype: "categorical",
                        });
                    });
                });
        }
        return state;
    };
};
exports.DataDictionaryReducer = DataDictionaryReducer;
//# sourceMappingURL=DataDictionaryReducer.js.map