"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MonacoEditor = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var api_1 = require("@kie-tools-core/editor/dist/api");
var hooks_1 = require("@kie-tools-core/envelope-bus/dist/hooks");
var path_1 = require("path");
var React = require("react");
var react_1 = require("react");
var MonacoEditorController_1 = require("./MonacoEditorController");
var extensionLanguageMap = new Map([
    [".yml", "yaml"],
    [".bpmn", "xml"],
    [".bpmn2", "xml"],
    [".dmn", "xml"],
    [".scesim", "xml"],
    [".pmml", "xml"],
    [".md", "markdown"],
]);
var RefForwardingMonacoEditor = function (_a, forwardedRef) {
    var _b;
    var content = _a.content, fileName = _a.fileName, onContentChange = _a.onContentChange, channelType = _a.channelType, isReadOnly = _a.isReadOnly, setValidationErrors = _a.setValidationErrors;
    var container = (0, react_1.useRef)(null);
    var editorEnvelopeCtx = (0, api_1.useKogitoEditorEnvelopeContext)();
    var _c = __read((0, hooks_1.useSharedValue)((_b = editorEnvelopeCtx.channelApi) === null || _b === void 0 ? void 0 : _b.shared.kogitoEditor_theme), 1), theme = _c[0];
    var controller = (0, react_1.useMemo)(function () {
        var _a;
        return new MonacoEditorController_1.MonacoEditorController(content, onContentChange, (_a = extensionLanguageMap.get((0, path_1.extname)(fileName.toLowerCase()))) !== null && _a !== void 0 ? _a : (0, path_1.extname)(fileName).slice(1), editorEnvelopeCtx.operatingSystem, isReadOnly, setValidationErrors);
    }, [content, editorEnvelopeCtx.operatingSystem, fileName, isReadOnly, onContentChange, setValidationErrors]);
    (0, react_1.useEffect)(function () {
        controller.forceRedraw();
    }, [controller]);
    (0, react_1.useEffect)(function () {
        if (!container.current) {
            return;
        }
        if (editorEnvelopeCtx.channelApi && theme === undefined) {
            return;
        }
        controller.show(container.current, theme !== null && theme !== void 0 ? theme : api_1.EditorTheme.LIGHT);
        return function () {
            controller.dispose();
        };
    }, [
        content,
        fileName,
        channelType,
        controller,
        theme,
        editorEnvelopeCtx.channelApi,
        editorEnvelopeCtx.operatingSystem,
    ]);
    (0, react_1.useImperativeHandle)(forwardedRef, function () { return controller; }, [controller]);
    return (0, jsx_runtime_1.jsx)("div", { style: { height: "100%" }, ref: container });
};
exports.MonacoEditor = React.forwardRef(RefForwardingMonacoEditor);
//# sourceMappingURL=MonacoEditor.js.map