import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import { useContext, useMemo, useRef, useState } from "react";
import "./BoxedExpressionEditorContext.css";
export const BoxedExpressionEditorContext = React.createContext({});
export const BoxedExpressionEditorDispatchContext = React.createContext({});
export function useBoxedExpressionEditor() {
    return useContext(BoxedExpressionEditorContext);
}
export function useBoxedExpressionEditorDispatch() {
    return useContext(BoxedExpressionEditorDispatchContext);
}
export function BoxedExpressionEditorContextProvider({ onExpressionChange, onWidthsChange, dataTypes, isReadOnly, expressionHolderId, beeGwtService, children, pmmlDocuments, evaluationHitsCountById, scrollableParentRef, onRequestFeelIdentifiers, widthsById, hideDmn14BoxedExpressions, }) {
    const [currentlyOpenContextMenu, setCurrentlyOpenContextMenu] = useState(undefined);
    const editorRef = useRef(null);
    const widthsByIdRef = useRef(widthsById);
    React.useEffect(() => {
        widthsByIdRef.current = widthsById;
    }, [widthsById]);
    const dispatch = useMemo(() => ({
        setExpression: onExpressionChange,
        setWidthsById: (mutation) => {
            const newWidthsById = new Map(widthsByIdRef.current);
            widthsByIdRef.current = newWidthsById;
            mutation({ newMap: newWidthsById });
            onWidthsChange(newWidthsById);
        },
    }), [onExpressionChange, onWidthsChange]);
    return (_jsx(BoxedExpressionEditorContext.Provider, { value: {
            beeGwtService,
            editorRef,
            scrollableParentRef,
            expressionHolderId,
            dataTypes,
            isReadOnly,
            pmmlDocuments,
            evaluationHitsCountById,
            currentlyOpenContextMenu,
            setCurrentlyOpenContextMenu,
            onRequestFeelIdentifiers,
            widthsById,
            hideDmn14BoxedExpressions,
        }, children: _jsx(BoxedExpressionEditorDispatchContext.Provider, { value: dispatch, children: _jsx("div", { className: "boxed-expression-provider", ref: editorRef, children: children }) }) }));
}
export function NestedExpressionDispatchContextProvider({ onSetExpression, children, }) {
    const { setWidthsById } = useBoxedExpressionEditorDispatch();
    const nestedExpressionDispatch = useMemo(() => {
        return {
            setExpression: (OnExpressionChange) => {
                function getNewExpression(prev) {
                    return typeof OnExpressionChange.setExpressionAction === "function"
                        ? OnExpressionChange.setExpressionAction(prev)
                        : OnExpressionChange.setExpressionAction;
                }
                onSetExpression({ getNewExpression, expressionChangedArgs: OnExpressionChange.expressionChangedArgs });
            },
            setWidthsById,
        };
    }, [onSetExpression, setWidthsById]);
    return (_jsx(BoxedExpressionEditorDispatchContext.Provider, { value: nestedExpressionDispatch, children: children }));
}
//# sourceMappingURL=BoxedExpressionEditorContext.js.map