import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { EmptyState, EmptyStateBody, EmptyStateIcon, EmptyStateVariant, } from "@patternfly/react-core/dist/js/components/EmptyState";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { SearchIcon } from "@patternfly/react-icons/dist/js/icons/search-icon";
import { InfoCircleIcon } from "@patternfly/react-icons/dist/js/icons/info-circle-icon";
import { ExclamationTriangleIcon } from "@patternfly/react-icons/dist/js/icons/exclamation-triangle-icon";
import { componentOuiaProps } from "../../ouiaTools";
export var KogitoEmptyStateType;
(function (KogitoEmptyStateType) {
    KogitoEmptyStateType[KogitoEmptyStateType["Search"] = 0] = "Search";
    KogitoEmptyStateType[KogitoEmptyStateType["Refresh"] = 1] = "Refresh";
    KogitoEmptyStateType[KogitoEmptyStateType["Reset"] = 2] = "Reset";
    KogitoEmptyStateType[KogitoEmptyStateType["Info"] = 3] = "Info";
})(KogitoEmptyStateType || (KogitoEmptyStateType = {}));
export const KogitoEmptyState = ({ type, title, body, onClick, ouiaId, ouiaSafe }) => {
    return (_jsx(Bullseye, { ...componentOuiaProps(ouiaId, "kogito-empty-state", ouiaSafe), children: _jsxs(EmptyState, { variant: EmptyStateVariant.full, children: [type === KogitoEmptyStateType.Search && _jsx(EmptyStateIcon, { icon: SearchIcon }), (type === KogitoEmptyStateType.Refresh || type === KogitoEmptyStateType.Reset) && (_jsx(EmptyStateIcon, { icon: ExclamationTriangleIcon, color: "var(--pf-global--warning-color--100)" })), type === KogitoEmptyStateType.Info && (_jsx(EmptyStateIcon, { icon: InfoCircleIcon, color: "var(--pf-global--info-color--100)" })), _jsx(Title, { headingLevel: "h5", size: "lg", children: title }), _jsx(EmptyStateBody, { children: body }), type === KogitoEmptyStateType.Refresh && (_jsx(Button, { variant: "primary", onClick: onClick, children: "Refresh" })), type === KogitoEmptyStateType.Reset && (_jsx(Button, { variant: "link", onClick: onClick, children: "Reset to default" }))] }) }));
};
export default KogitoEmptyState;
//# sourceMappingURL=KogitoEmptyState.js.map