import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Flex, FlexItem } from "@patternfly/react-core/dist/js/layouts/Flex";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { componentOuiaProps } from "../../ouiaTools";
export const PageTitle = ({ title, extra, ouiaId, ouiaSafe }) => {
    return (_jsxs(Flex, { ...componentOuiaProps(ouiaId, "page-title", ouiaSafe), children: [_jsx(FlexItem, { spacer: { default: "spacerSm" }, children: _jsx(Title, { headingLevel: "h1", size: "4xl", children: title }) }), extra ? _jsx(FlexItem, { spacer: { default: "spacerSm" }, children: extra }) : null] }));
};
//# sourceMappingURL=PageTitle.js.map