export class ModelConversionTool {
}
ModelConversionTool.convertDateToString = (model, schema) => {
    return doConvert(model, schema, (value) => value.toISOString());
};
ModelConversionTool.convertStringToDate = (model, schema) => {
    return doConvert(model, schema, (value) => new Date(value));
};
class ConversionContext {
    constructor(args) {
        this.definitions = args.defintions;
        this.rootSchema = args.rootSchema;
        this.rootModel = args.rootModel;
        this.convert = args.conversion;
    }
    lookupDefinition(ref) {
        if (!this.definitions) {
            return undefined;
        }
        const index = ref.lastIndexOf("/");
        if (index === -1) {
            return undefined;
        }
        return this.definitions[ref.substring(index + 1)];
    }
}
function doConvert(model, schema, conversion) {
    const ctx = new ConversionContext({
        rootSchema: schema,
        rootModel: model,
        defintions: schema.definitions || schema.$defs,
        conversion,
    });
    return convertModel(model, schema, ctx);
}
function convertModel(model, schema, ctx) {
    const obj = {};
    if (!model) {
        return obj;
    }
    if (!schema.properties) {
        return obj;
    }
    Object.keys(model).forEach((propertyName) => {
        const property = schema.properties[propertyName];
        const value = model[propertyName];
        if (value === null) {
            return;
        }
        if (!property) {
            obj[propertyName] = value;
            return;
        }
        const props = lookupSchemaPropertyProps(property, ctx);
        switch (props.type) {
            case "object":
                obj[propertyName] = convertModel(value, props, ctx);
                break;
            case "array":
                if (property.items) {
                    const itemProps = lookupSchemaPropertyProps(props.items, ctx);
                    if (itemProps.type === "object") {
                        obj[propertyName] = value.map((item) => convertModel(item, itemProps, ctx));
                    }
                    else {
                        obj[propertyName] = value;
                    }
                }
                else {
                    obj[propertyName] = value;
                }
                break;
            case "string":
                switch (props.format) {
                    case "date-time":
                    case "date":
                        obj[propertyName] = ctx.convert(value);
                        break;
                    default:
                        obj[propertyName] = value;
                        break;
                }
                break;
            default:
                obj[propertyName] = value;
                break;
        }
    });
    return obj;
}
function lookupSchemaPropertyProps(property, ctx) {
    if (property["$ref"]) {
        return ctx.lookupDefinition(property["$ref"]) || property;
    }
    if (property["allOf"]) {
        const allOf = property.allOf;
        const refItem = allOf.find((item) => item["$ref"]);
        if (refItem) {
            return ctx.lookupDefinition(refItem["$ref"]);
        }
    }
    return property;
}
//# sourceMappingURL=ModelConversionTool.js.map