import { jsx as _jsx } from "react/jsx-runtime";
import React, { useCallback, useMemo } from "react";
import { RefForwardingEmbeddedEnvelope } from "@kie-tools-core/envelope/dist/embedded";
import { TaskInboxChannelApiImpl } from "./TaskInboxChannelApiImpl";
import { ContainerType } from "@kie-tools-core/envelope/dist/api";
import { init } from "../envelope";
export const EmbeddedTaskInbox = React.forwardRef((props, forwardedRef) => {
    const refDelegate = useCallback((envelopeServer) => ({
        taskInbox__notify: (userName) => envelopeServer.envelopeApi.requests.taskInbox__notify(userName),
    }), []);
    const pollInit = useCallback(async (envelopeServer, container) => {
        await init({
            config: {
                containerType: ContainerType.DIV,
                envelopeId: envelopeServer.id,
            },
            container: container(),
            bus: {
                postMessage(message, targetOrigin, transfer) {
                    window.postMessage(message, targetOrigin, transfer);
                },
            },
        });
        return await envelopeServer.envelopeApi.requests.taskInbox__init({
            origin: envelopeServer.origin,
            envelopeServerId: envelopeServer.id,
        }, {
            initialState: props.initialState,
            allTaskStates: props.allTaskStates,
            activeTaskStates: props.activeTaskStates,
        });
    }, [props.initialState, props.allTaskStates, props.activeTaskStates]);
    const apiImpl = useMemo(() => new TaskInboxChannelApiImpl(props.driver), [props.driver]);
    return (_jsx(EmbeddedTaskInboxEnvelope, { ref: forwardedRef, apiImpl: apiImpl, origin: props.targetOrigin, refDelegate: refDelegate, pollInit: pollInit, config: { containerType: ContainerType.DIV } }));
});
const EmbeddedTaskInboxEnvelope = React.forwardRef(RefForwardingEmbeddedEnvelope);
//# sourceMappingURL=EmbeddedTaskInbox.js.map