import { DC__Bounds } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/ts-gen/types";
import * as Elk from "elkjs/lib/elk.bundled.js";
import { Edge, Node } from "reactflow";
import { DmnDiagramEdgeData } from "../diagram/edges/Edges";
import { DrgEdge } from "../diagram/graph/graph";
import { DmnDiagramNodeData } from "../diagram/nodes/Nodes";
import { SnapGrid } from "../store/Store";
export declare const ELK_OPTIONS: {
    "elk.algorithm": string;
    "elk.direction": string;
    "elk.aspectRatio": string;
    "elk.spacing.nodeNode": string;
    "elk.spacing.componentComponent": string;
    "layered.spacing.edgeEdgeBetweenLayers": string;
    "layered.spacing.edgeNodeBetweenLayers": string;
    "layered.spacing.nodeNodeBetweenLayers": string;
    "elk.edgeRouting": string;
    "elk.layered.mergeEdges": string;
    "elk.layered.mergeHierarchyEdges": string;
    "elk.partitioning.activate": string;
    "elk.nodePlacement.favorStraightEdges": string;
    "elk.nodePlacement.bk.fixedAlignment": string;
    "elk.nodePlacement.bk.edgeStraightening": string;
    "layering.strategy": string;
};
export interface AutolayoutParentNode {
    decisionServiceSection: "output" | "encapsulated" | "n/a";
    elkNode: Elk.ElkNode;
    contained: Set<string>;
    dependents: Set<string>;
    dependencies: Set<string>;
    contains: (otherNode: {
        id: string;
        bounds: DC__Bounds | undefined;
    }) => {
        isInside: boolean;
        decisionServiceSection: AutolayoutParentNode["decisionServiceSection"];
    };
    hasDependencyTo: (otherNode: {
        id: string;
    }) => boolean;
    isDependencyOf: (otherNode: {
        id: string;
    }) => boolean;
}
export declare const FAKE_MARKER = "__$FAKE$__";
export declare function getAutoLayoutedInfo({ __readonly_snapGrid, __readonly_nodesById, __readonly_edgesById, __readonly_nodes, __readonly_drgEdges, __readonly_isAlternativeInputDataShape, }: {
    __readonly_snapGrid: SnapGrid;
    __readonly_nodesById: Map<string, Node<DmnDiagramNodeData, string | undefined>>;
    __readonly_edgesById: Map<string, Edge<DmnDiagramEdgeData>>;
    __readonly_nodes: Node<DmnDiagramNodeData, string | undefined>[];
    __readonly_drgEdges: DrgEdge[];
    __readonly_isAlternativeInputDataShape: boolean;
}): Promise<{
    __readonly_autoLayoutedInfo: {
        isHorizontal: boolean;
        nodes: Elk.ElkNode[] | undefined;
        edges: Elk.ElkExtendedEdge[] | undefined;
    };
    __readonly_parentNodesById: Map<string, AutolayoutParentNode>;
}>;
export declare function visitNodeAndNested(elkNode: Elk.ElkNode, positionOffset: {
    x: number;
    y: number;
}, visitor: (elkNode: Elk.ElkNode, positionOffset: {
    x: number;
    y: number;
}) => void): void;
//# sourceMappingURL=autoLayoutInfo.d.ts.map