import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useCallback, useMemo } from "react";
import { DescriptionField, NameField, TypeRefField } from "../Fields";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../../store/StoreContext";
import { ClipboardCopy } from "@patternfly/react-core/dist/js/components/ClipboardCopy";
import { FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { useDmnEditor } from "../../DmnEditorContext";
import { ConstraintsFromTypeConstraintAttribute } from "../../dataTypes/Constraints";
import { useExternalModels } from "../../includedModels/DmnEditorDependenciesContext";
export function InformationItemCell(props) {
    var _a, _b, _c, _d;
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const selectedObjectId = useDmnEditorStore((s) => s.boxedExpressionEditor.selectedObjectId);
    const { externalModelsByNamespace } = useExternalModels();
    const { dmnEditorRootElementRef } = useDmnEditor();
    const selectedObjectInfos = useMemo(() => { var _a; return (_a = props.boxedExpressionIndex) === null || _a === void 0 ? void 0 : _a.get(selectedObjectId !== null && selectedObjectId !== void 0 ? selectedObjectId : ""); }, [props.boxedExpressionIndex, selectedObjectId]);
    const cell = useMemo(() => selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.cell, [selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.cell]);
    const itemDefinition = useMemo(() => {
        var _a, _b, _c;
        const { allDataTypesById, allTopLevelItemDefinitionUniqueNames } = dmnEditorStoreApi
            .getState()
            .computed(dmnEditorStoreApi.getState())
            .getDataTypes(externalModelsByNamespace);
        return (_c = allDataTypesById.get((_b = allTopLevelItemDefinitionUniqueNames.get((_a = cell === null || cell === void 0 ? void 0 : cell["@_typeRef"]) !== null && _a !== void 0 ? _a : "")) !== null && _b !== void 0 ? _b : "")) === null || _c === void 0 ? void 0 : _c.itemDefinition;
    }, [cell, dmnEditorStoreApi, externalModelsByNamespace]);
    const getAllUniqueNames = useCallback((s) => new Map(), []);
    return (_jsxs(_Fragment, { children: [_jsx(FormGroup, { label: "ID", children: _jsx(ClipboardCopy, { isReadOnly: true, hoverTip: "Copy", clickTip: "Copied", children: selectedObjectId }) }), _jsx(NameField, { isReadOnly: props.isReadOnly, id: cell["@_id"], name: (_a = cell["@_name"]) !== null && _a !== void 0 ? _a : "", getAllUniqueNames: getAllUniqueNames, onChange: props.onNameChange }), _jsx(TypeRefField, { isReadOnly: props.isReadOnly, typeRef: cell["@_typeRef"], dmnEditorRootElementRef: dmnEditorRootElementRef, onChange: props.onTypeRefChange }), itemDefinition && (_jsx(FormGroup, { label: "Constraint", children: _jsx(ConstraintsFromTypeConstraintAttribute, { isReadOnly: true, itemDefinition: itemDefinition, editItemDefinition: () => { }, renderOnPropertiesPanel: true, defaultsToAllowedValues: true }) })), _jsx(DescriptionField, { isReadOnly: props.isReadOnly, initialValue: (_c = (_b = cell.description) === null || _b === void 0 ? void 0 : _b.__$$text) !== null && _c !== void 0 ? _c : "", expressionPath: (_d = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _d !== void 0 ? _d : [], onChange: props.onDescriptionChange })] }));
}
//# sourceMappingURL=InformationItemCell.js.map