export var BoxedExpressionPropertiesPanelComponent;
(function (BoxedExpressionPropertiesPanelComponent) {
    BoxedExpressionPropertiesPanelComponent["CONTEXT_INFORMATION_ITEM_CELL"] = "context-information-item-cell";
    BoxedExpressionPropertiesPanelComponent["DECISION_TABLE_INPUT_HEADER"] = "decision-table-input-header";
    BoxedExpressionPropertiesPanelComponent["DECISION_TABLE_INPUT_RULE"] = "decision-table-input-rule";
    BoxedExpressionPropertiesPanelComponent["DECISION_TABLE_OUTPUT_HEADER"] = "decision-table-output-header";
    BoxedExpressionPropertiesPanelComponent["DECISION_TABLE_OUTPUT_RULE"] = "decision-table-output-rule";
    BoxedExpressionPropertiesPanelComponent["DECISION_TABLE_ROOT"] = "decision-table-root";
    BoxedExpressionPropertiesPanelComponent["EXPRESSION_ROOT"] = "expression-root";
    BoxedExpressionPropertiesPanelComponent["FUNCTION_DEFINITION_PARAMETERS"] = "function-definition-parameters";
    BoxedExpressionPropertiesPanelComponent["FUNCTION_DEFINITION_ROOT"] = "function-definition-root";
    BoxedExpressionPropertiesPanelComponent["INVOCATION_FUNCTION_CALL"] = "invocation-function-call";
    BoxedExpressionPropertiesPanelComponent["INVOCATION_INFORMATION_ITEM_CELL"] = "invocation-information-item-cell";
    BoxedExpressionPropertiesPanelComponent["ITERATOR_VARIABLE_CELL"] = "iterator-variable-cell";
    BoxedExpressionPropertiesPanelComponent["LITERAL_EXPRESSION_CONTENT"] = "literal-expression-content";
    BoxedExpressionPropertiesPanelComponent["RELATION_INFORMATION_ITEM_CELL"] = "relation-information-item-cell";
    BoxedExpressionPropertiesPanelComponent["WITHOUT_PROPERTIES_CELL"] = "without-properties-cell";
})(BoxedExpressionPropertiesPanelComponent || (BoxedExpressionPropertiesPanelComponent = {}));
export function getBoxedExpressionPropertiesPanelComponent(selectedObjectPath) {
    if (selectedObjectPath.type === "conditional") {
        if (selectedObjectPath.row === undefined) {
            return { component: BoxedExpressionPropertiesPanelComponent.EXPRESSION_ROOT, title: "Boxed Conditional" };
        }
    }
    if (selectedObjectPath.type === "context") {
        if (selectedObjectPath.column === undefined) {
            return { component: BoxedExpressionPropertiesPanelComponent.EXPRESSION_ROOT, title: "Boxed Context" };
        }
        if (selectedObjectPath.column === "variable") {
            return {
                component: BoxedExpressionPropertiesPanelComponent.CONTEXT_INFORMATION_ITEM_CELL,
                title: "Boxed Context Variable",
            };
        }
    }
    if (selectedObjectPath.type === "decisionTable") {
        if (selectedObjectPath.row === undefined) {
            return { component: BoxedExpressionPropertiesPanelComponent.DECISION_TABLE_ROOT, title: "Decision Table" };
        }
        if (selectedObjectPath.header === "input") {
            if (selectedObjectPath.row < 0) {
                return {
                    component: BoxedExpressionPropertiesPanelComponent.DECISION_TABLE_INPUT_HEADER,
                    title: "Decision Table Input Header",
                };
            }
            return {
                component: BoxedExpressionPropertiesPanelComponent.DECISION_TABLE_INPUT_RULE,
                title: "Decision Table Input Cell",
            };
        }
        if (selectedObjectPath.header === "output") {
            if (selectedObjectPath.row < 0) {
                return {
                    component: BoxedExpressionPropertiesPanelComponent.DECISION_TABLE_OUTPUT_HEADER,
                    title: "Decision Table Output Header",
                };
            }
            return {
                component: BoxedExpressionPropertiesPanelComponent.DECISION_TABLE_OUTPUT_RULE,
                title: "Decision Table Output Cell",
            };
        }
    }
    if (selectedObjectPath.type === "every") {
        if (selectedObjectPath.row === undefined) {
            return { component: BoxedExpressionPropertiesPanelComponent.EXPRESSION_ROOT, title: "Boxed Every" };
        }
        if (selectedObjectPath.row === "variable") {
            return {
                component: BoxedExpressionPropertiesPanelComponent.ITERATOR_VARIABLE_CELL,
                title: "Boxed Every Variable",
            };
        }
    }
    if (selectedObjectPath.type === "filter") {
        if (selectedObjectPath.row === undefined) {
            return { component: BoxedExpressionPropertiesPanelComponent.EXPRESSION_ROOT, title: "Boxed Filter" };
        }
    }
    if (selectedObjectPath.type === "for") {
        if (selectedObjectPath.row === undefined) {
            return { component: BoxedExpressionPropertiesPanelComponent.EXPRESSION_ROOT, title: "Boxed For" };
        }
        if (selectedObjectPath.row === "variable") {
            return { component: BoxedExpressionPropertiesPanelComponent.ITERATOR_VARIABLE_CELL, title: "Boxed For Variable" };
        }
    }
    if (selectedObjectPath.type === "functionDefinition") {
        if (selectedObjectPath.parameterIndex === undefined) {
            return {
                component: BoxedExpressionPropertiesPanelComponent.FUNCTION_DEFINITION_ROOT,
                title: "Function Definition",
            };
        }
        return {
            component: BoxedExpressionPropertiesPanelComponent.FUNCTION_DEFINITION_PARAMETERS,
            title: "Function Parameters",
        };
    }
    if (selectedObjectPath.type === "invocation") {
        if (selectedObjectPath.row === undefined || selectedObjectPath.column === undefined) {
            return {
                component: BoxedExpressionPropertiesPanelComponent.EXPRESSION_ROOT,
                title: "Boxed Invocation",
            };
        }
        if (selectedObjectPath.row < 0) {
            return {
                component: BoxedExpressionPropertiesPanelComponent.INVOCATION_FUNCTION_CALL,
                title: "Boxed Invocation Called Function",
            };
        }
        if (selectedObjectPath.column === "parameter") {
            return {
                component: BoxedExpressionPropertiesPanelComponent.INVOCATION_INFORMATION_ITEM_CELL,
                title: "Boxed Invocation Parameter",
            };
        }
        if (selectedObjectPath.column === "expression") {
            return {
                component: BoxedExpressionPropertiesPanelComponent.LITERAL_EXPRESSION_CONTENT,
                title: "Boxed Invocation",
            };
        }
    }
    if (selectedObjectPath.type === "list") {
        if (selectedObjectPath.row === undefined) {
            return { component: BoxedExpressionPropertiesPanelComponent.EXPRESSION_ROOT, title: "Boxed List" };
        }
    }
    if (selectedObjectPath.type === "literalExpression") {
        return {
            component: BoxedExpressionPropertiesPanelComponent.LITERAL_EXPRESSION_CONTENT,
            title: "Literal Expression",
        };
    }
    if (selectedObjectPath.type === "relation") {
        if (selectedObjectPath.row === undefined) {
            return { component: BoxedExpressionPropertiesPanelComponent.EXPRESSION_ROOT, title: "Boxed Relation" };
        }
        if (selectedObjectPath.row < 0) {
            return {
                component: BoxedExpressionPropertiesPanelComponent.RELATION_INFORMATION_ITEM_CELL,
                title: "Boxed Relation Header",
            };
        }
        return {
            component: BoxedExpressionPropertiesPanelComponent.LITERAL_EXPRESSION_CONTENT,
            title: "Boxed Relation Cell",
        };
    }
    if (selectedObjectPath.type === "some") {
        if (selectedObjectPath.row === undefined) {
            return { component: BoxedExpressionPropertiesPanelComponent.EXPRESSION_ROOT, title: "Boxed Some" };
        }
        if (selectedObjectPath.row === "variable") {
            return {
                component: BoxedExpressionPropertiesPanelComponent.ITERATOR_VARIABLE_CELL,
                title: "Boxed Some Variable",
            };
        }
    }
    return { component: BoxedExpressionPropertiesPanelComponent.WITHOUT_PROPERTIES_CELL, title: "" };
}
//# sourceMappingURL=getBoxedExpressionPropertiesPanelComponent.js.map