/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile.util;

import java.util.Arrays;
import java.util.Random;

public abstract class KLLSketchForQuantile {
    long n;
    int maxMemoryNum;
    long[] num;
    boolean level0Sorted;
    int cntLevel;
    int[] levelPos;
    int[] levelMaxSize;
    long XORSHIFT = new Random().nextInt();

    protected KLLSketchForQuantile() {
    }

    protected abstract int calcMaxMemoryNum(int var1);

    protected abstract void calcLevelMaxSize(int var1);

    public int getLevelSize(int level) {
        return this.levelPos[level + 1] - this.levelPos[level];
    }

    public void update(long x) {
        if (this.levelPos[0] == 0) {
            this.compact();
        }
        this.levelPos[0] = this.levelPos[0] - 1;
        this.num[this.levelPos[0]] = x;
        ++this.n;
        this.level0Sorted = false;
    }

    protected abstract void compact();

    protected int getNextRand01() {
        this.XORSHIFT ^= this.XORSHIFT >>> 12;
        this.XORSHIFT ^= this.XORSHIFT << 25;
        this.XORSHIFT ^= this.XORSHIFT >>> 27;
        return (int)(this.XORSHIFT * 2685821657736338717L & 1L);
    }

    protected void randomlyHalveDownToLeft(int l, int r) {
        int delta = this.getNextRand01();
        int mid = l + r >>> 1;
        int i = l;
        int j = l;
        while (i < mid) {
            this.num[i] = this.num[j + delta];
            ++i;
            j += 2;
        }
    }

    protected void mergeSortWithoutSpace(int l1, int mid, int l2, int r2) {
        int p1 = l1;
        int p2 = l2;
        int cntPos = mid;
        while (p1 < mid || p2 < r2) {
            if (p1 < mid && (p2 == r2 || this.num[p1] < this.num[p2])) {
                this.num[cntPos++] = this.num[p1++];
                continue;
            }
            this.num[cntPos++] = this.num[p2++];
        }
    }

    protected int findRankInLevel(int level, long v) {
        int l = this.levelPos[level];
        int r = this.levelPos[level + 1];
        if (level == 0 && !this.level0Sorted) {
            Arrays.sort(this.num, l, r);
            this.level0Sorted = true;
        }
        if (l > --r || this.num[l] >= v) {
            return 0;
        }
        while (l < r) {
            int mid = l + r + 1 >> 1;
            if (this.num[mid] < v) {
                l = mid;
                continue;
            }
            r = mid - 1;
        }
        return (l - this.levelPos[level] + 1) * (1 << level);
    }

    public int getApproxRank(long v) {
        int approxRank = 0;
        for (int i = 0; i < this.cntLevel; ++i) {
            approxRank += this.findRankInLevel(i, v);
        }
        return approxRank;
    }

    public long findMaxValueWithRank(long k) {
        long l = Long.MIN_VALUE;
        long r = Long.MAX_VALUE;
        while (l < r) {
            long mid = l + (r - l >>> 1);
            if (mid == l) {
                ++mid;
            }
            if ((long)this.getApproxRank(mid) <= k) {
                l = mid;
                continue;
            }
            r = mid - 1L;
        }
        return l;
    }

    public long findMinValueWithRank(long k) {
        long l = Long.MIN_VALUE;
        long r = Long.MAX_VALUE;
        while (l < r) {
            long mid = l + (r - l >>> 1);
            if (mid == r) {
                --mid;
            }
            if ((long)this.getApproxRank(mid) >= k) {
                r = mid;
                continue;
            }
            l = mid + 1L;
        }
        return l;
    }

    public long getN() {
        return this.n;
    }

    public int getMaxMemoryNum() {
        return this.maxMemoryNum;
    }

    public int getNumLen() {
        return this.levelPos[this.cntLevel] - this.levelPos[0];
    }

    public boolean exactResult() {
        return this.n == (long)this.getNumLen();
    }

    public long getExactResult(int k) {
        int l = this.levelPos[0];
        int r = this.levelPos[1];
        if (!this.level0Sorted) {
            Arrays.sort(this.num, l, r);
            this.level0Sorted = true;
        }
        return this.num[l + k];
    }
}

