/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.tsfile;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.tool.common.Constants;
import org.apache.iotdb.tool.common.OptionsUtil;
import org.apache.iotdb.tool.tsfile.subscription.AbstractSubscriptionTsFile;
import org.apache.iotdb.tool.tsfile.subscription.CommonParam;
import org.slf4j.LoggerFactory;

public class ExportTsFile {
    private static final IoTPrinter ioTPrinter = new IoTPrinter(System.out);
    private static CommonParam commonParam = CommonParam.getInstance();

    public static void main(String[] args) throws Exception {
        Logger logger = (Logger)LoggerFactory.getLogger((String)"org.apache.iotdb.session.subscription.consumer.base");
        logger.setLevel(Level.WARN);
        Options options = OptionsUtil.createSubscriptionTsFileOptions();
        ExportTsFile.parseParams(args, options);
        if (StringUtils.isEmpty((CharSequence)commonParam.getPath())) {
            CommonParam.setSqlDialect("table");
        }
        AbstractSubscriptionTsFile.setSubscriptionSession();
        String nowFormat = Constants.DATE_FORMAT_VIEW.format(System.currentTimeMillis());
        String topicName = "topic_" + nowFormat;
        String groupId = "group_" + nowFormat;
        commonParam.getSubscriptionTsFile().createTopics(topicName);
        commonParam.getSubscriptionTsFile().createConsumers(groupId);
        commonParam.getSubscriptionTsFile().subscribe(topicName);
        ExecutorService executor = Executors.newFixedThreadPool(commonParam.getConsumerCount());
        commonParam.getSubscriptionTsFile().consumerPoll(executor, topicName);
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        commonParam.getSubscriptionTsFile().doClean();
        ioTPrinter.println("Export TsFile Count: " + commonParam.getCountFile().get());
    }

    private static void parseParams(String[] args, Options options) {
        HelpFormatter hf = new HelpFormatter();
        hf.setOptionComparator(null);
        CommandLine cli = null;
        DefaultParser cliParser = new DefaultParser();
        try {
            cli = cliParser.parse(options, args);
            if (cli.hasOption("help") || args.length == 0) {
                hf.printHelp("Export TsFile", options, true);
                System.exit(0);
            }
            if (cli.hasOption("sql_dialect")) {
                CommonParam.setSqlDialect(cli.getOptionValue("sql_dialect"));
            }
            if (cli.hasOption("h")) {
                CommonParam.setSrcHost(cli.getOptionValue("h"));
            }
            if (cli.hasOption("p")) {
                CommonParam.setSrcPort(Integer.valueOf(cli.getOptionValue("p")));
            }
            if (cli.hasOption("u")) {
                CommonParam.setSrcUserName(cli.getOptionValue("u"));
            }
            if (cli.hasOption("pw")) {
                CommonParam.setSrcPassword(cli.getOptionValue("pw"));
            }
            if (cli.hasOption("path")) {
                CommonParam.setPath(cli.getOptionValue("path"));
            }
            if (cli.hasOption("db")) {
                CommonParam.setDatabase(cli.getOptionValue("db"));
            }
            if (cli.hasOption("table")) {
                CommonParam.setTable(cli.getOptionValue("table"));
            }
            if (cli.hasOption("t")) {
                CommonParam.setTargetDir(cli.getOptionValue("t"));
            }
            if (cli.hasOption("start_time")) {
                CommonParam.setStartTime(cli.getOptionValue("start_time"));
            }
            if (cli.hasOption("end_time")) {
                CommonParam.setEndTime(cli.getOptionValue("end_time"));
            }
            if (cli.hasOption("tn")) {
                CommonParam.setConsumerCount(Integer.valueOf(cli.getOptionValue("tn")));
            }
        }
        catch (ParseException e) {
            ioTPrinter.println(e.getMessage());
            hf.printHelp("Export TsFile", options, true);
            System.exit(1);
        }
    }
}

