/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.process;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByParameter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class RawDataAggregationNode
extends SingleChildProcessNode {
    protected List<AggregationDescriptor> aggregationDescriptorList;
    @Nullable
    protected GroupByTimeParameter groupByTimeParameter;
    @Nullable
    protected GroupByParameter groupByParameter;
    protected Expression groupByExpression;
    protected Ordering scanOrder;
    protected boolean outputEndTime = false;

    public RawDataAggregationNode(PlanNodeId id, List<AggregationDescriptor> aggregationDescriptorList, @Nullable GroupByTimeParameter groupByTimeParameter, Ordering scanOrder) {
        super(id);
        this.aggregationDescriptorList = AggregationNode.getDeduplicatedDescriptors(aggregationDescriptorList);
        this.groupByTimeParameter = groupByTimeParameter;
        this.scanOrder = scanOrder;
    }

    public RawDataAggregationNode(PlanNodeId id, PlanNode child, List<AggregationDescriptor> aggregationDescriptorList, @Nullable GroupByTimeParameter groupByTimeParameter, Ordering scanOrder) {
        super(id, child);
        this.aggregationDescriptorList = AggregationNode.getDeduplicatedDescriptors(aggregationDescriptorList);
        this.groupByTimeParameter = groupByTimeParameter;
        this.scanOrder = scanOrder;
    }

    public RawDataAggregationNode(PlanNodeId id, List<AggregationDescriptor> aggregationDescriptorList, @Nullable GroupByTimeParameter groupByTimeParameter, @Nullable GroupByParameter groupByParameter, Expression groupByExpression, boolean outputEndTime, Ordering scanOrder) {
        super(id);
        this.aggregationDescriptorList = aggregationDescriptorList;
        this.groupByTimeParameter = groupByTimeParameter;
        this.scanOrder = scanOrder;
        this.groupByParameter = groupByParameter;
        this.groupByExpression = groupByExpression;
        this.outputEndTime = outputEndTime;
    }

    public RawDataAggregationNode(PlanNodeId id, PlanNode child, List<AggregationDescriptor> aggregationDescriptorList, @Nullable GroupByTimeParameter groupByTimeParameter, @Nullable GroupByParameter groupByParameter, Expression groupByExpression, boolean outputEndTime, Ordering scanOrder) {
        super(id, child);
        this.aggregationDescriptorList = AggregationNode.getDeduplicatedDescriptors(aggregationDescriptorList);
        this.scanOrder = scanOrder;
        this.groupByParameter = groupByParameter;
        this.groupByTimeParameter = groupByTimeParameter;
        this.groupByExpression = groupByExpression;
        this.outputEndTime = outputEndTime;
    }

    public RawDataAggregationNode(PlanNodeId id, PlanNode child, List<AggregationDescriptor> deduplicatedAggregationDescriptorList, @Nullable GroupByTimeParameter groupByTimeParameter, @Nullable GroupByParameter groupByParameter, Expression groupByExpression, boolean outputEndTime, Ordering scanOrder, boolean useDeduplicatedDescriptors) {
        super(id, child);
        this.aggregationDescriptorList = deduplicatedAggregationDescriptorList;
        this.scanOrder = scanOrder;
        this.groupByParameter = groupByParameter;
        this.groupByTimeParameter = groupByTimeParameter;
        this.groupByExpression = groupByExpression;
        this.outputEndTime = outputEndTime;
    }

    public List<AggregationDescriptor> getAggregationDescriptorList() {
        return this.aggregationDescriptorList;
    }

    @Nullable
    public GroupByTimeParameter getGroupByTimeParameter() {
        return this.groupByTimeParameter;
    }

    @Nullable
    public GroupByParameter getGroupByParameter() {
        return this.groupByParameter;
    }

    public Ordering getScanOrder() {
        return this.scanOrder;
    }

    public boolean isOutputEndTime() {
        return this.outputEndTime;
    }

    public void setOutputEndTime(boolean outputEndTime) {
        this.outputEndTime = outputEndTime;
    }

    @Nullable
    public Expression getGroupByExpression() {
        return this.groupByExpression;
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.RAW_DATA_AGGREGATION;
    }

    @Override
    public PlanNode clone() {
        return new RawDataAggregationNode(this.getPlanNodeId(), this.getAggregationDescriptorList(), this.getGroupByTimeParameter(), this.getGroupByParameter(), this.getGroupByExpression(), this.outputEndTime, this.getScanOrder());
    }

    @Override
    public List<String> getOutputColumnNames() {
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        if (this.outputEndTime) {
            outputColumnNames.add("__endTime");
        }
        outputColumnNames.addAll(this.aggregationDescriptorList.stream().map(AggregationDescriptor::getOutputColumnNames).flatMap(Collection::stream).collect(Collectors.toList()));
        return outputColumnNames;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitRawDataAggregation(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.RAW_DATA_AGGREGATION.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.aggregationDescriptorList.size(), (ByteBuffer)byteBuffer);
        for (AggregationDescriptor aggregationDescriptor : this.aggregationDescriptorList) {
            aggregationDescriptor.serialize(byteBuffer);
        }
        if (this.groupByTimeParameter == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            this.groupByTimeParameter.serialize(byteBuffer);
        }
        if (this.groupByParameter == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            this.groupByParameter.serialize(byteBuffer);
        }
        if (this.groupByExpression == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            Expression.serialize(this.groupByExpression, byteBuffer);
        }
        ReadWriteIOUtils.write((Boolean)this.outputEndTime, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.RAW_DATA_AGGREGATION.serialize(stream);
        ReadWriteIOUtils.write((int)this.aggregationDescriptorList.size(), (OutputStream)stream);
        for (AggregationDescriptor aggregationDescriptor : this.aggregationDescriptorList) {
            aggregationDescriptor.serialize(stream);
        }
        if (this.groupByTimeParameter == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            this.groupByTimeParameter.serialize(stream);
        }
        if (this.groupByParameter == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            this.groupByParameter.serialize(stream);
        }
        if (this.groupByExpression == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            Expression.serialize(this.groupByExpression, stream);
        }
        ReadWriteIOUtils.write((Boolean)this.outputEndTime, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (OutputStream)stream);
    }

    public static RawDataAggregationNode deserialize(ByteBuffer byteBuffer) {
        ArrayList<AggregationDescriptor> aggregationDescriptorList = new ArrayList<AggregationDescriptor>();
        for (int descriptorSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer); descriptorSize > 0; --descriptorSize) {
            aggregationDescriptorList.add(AggregationDescriptor.deserialize(byteBuffer));
        }
        byte isNull = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        GroupByTimeParameter groupByTimeParameter = null;
        if (isNull == 1) {
            groupByTimeParameter = GroupByTimeParameter.deserialize(byteBuffer);
        }
        isNull = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        GroupByParameter groupByParameter = null;
        if (isNull == 1) {
            groupByParameter = GroupByParameter.deserialize(byteBuffer);
        }
        isNull = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        Expression groupByExpression = null;
        if (isNull == 1) {
            groupByExpression = Expression.deserialize(byteBuffer);
        }
        boolean outputEndTime = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        Ordering scanOrder = Ordering.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new RawDataAggregationNode(planNodeId, aggregationDescriptorList, groupByTimeParameter, groupByParameter, groupByExpression, outputEndTime, scanOrder);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RawDataAggregationNode that = (RawDataAggregationNode)o;
        return Objects.equals(this.aggregationDescriptorList, that.aggregationDescriptorList) && Objects.equals(this.groupByTimeParameter, that.groupByTimeParameter) && Objects.equals(this.groupByParameter, that.groupByParameter) && Objects.equals(this.groupByExpression, that.groupByExpression) && Objects.equals(this.outputEndTime, that.outputEndTime) && this.scanOrder == that.scanOrder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.aggregationDescriptorList, this.groupByTimeParameter, this.groupByParameter, this.groupByExpression, this.outputEndTime, this.scanOrder});
    }

    public String toString() {
        return String.format("RawDataAggregationNode-%s", this.getPlanNodeId());
    }
}

