/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.validation;

import java.util.Optional;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.webadmin.dto.QuotaDTO;
import org.apache.james.webadmin.dto.ValidatedQuotaDTO;
import org.apache.james.webadmin.utils.ErrorResponder;

public class QuotaDTOValidator {
    private static final int UNLIMITED = -1;

    public ValidatedQuotaDTO validatedQuotaDTO(QuotaDTO quotaDTO) {
        try {
            Optional<QuotaCountLimit> count = quotaDTO.getCount().map(this::getQuotaCount);
            Optional<QuotaSizeLimit> size = quotaDTO.getSize().map(this::getQuotaSize);
            return ValidatedQuotaDTO.builder().count(count).size(size).build();
        }
        catch (IllegalArgumentException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Invalid quota. Need to be an integer value greater or equal to -1").cause((Exception)e).haltError();
        }
    }

    private QuotaSizeLimit getQuotaSize(Long quotaValue) {
        if (quotaValue == -1L) {
            return QuotaSizeLimit.unlimited();
        }
        return QuotaSizeLimit.size((long)quotaValue);
    }

    private QuotaCountLimit getQuotaCount(Long quotaValue) {
        if (quotaValue == -1L) {
            return QuotaCountLimit.unlimited();
        }
        return QuotaCountLimit.count((long)quotaValue);
    }
}

