/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch;

import java.io.IOException;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.ApiClient;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch.core.SearchShardsRequest;
import org.opensearch.client.opensearch.core.SearchShardsResponse;
import org.opensearch.client.opensearch.ml.OpenSearchMlClient;
import org.opensearch.client.opensearch.search_pipeline.OpenSearchSearchPipelineClient;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.TransportOptions;
import org.opensearch.client.util.ObjectBuilder;

public abstract class OpenSearchClientBase<Self extends OpenSearchClientBase<Self>>
extends ApiClient<OpenSearchTransport, Self> {
    public OpenSearchClientBase(OpenSearchTransport transport, @Nullable TransportOptions transportOptions) {
        super(transport, transportOptions);
    }

    public OpenSearchMlClient ml() {
        return new OpenSearchMlClient((OpenSearchTransport)this.transport, this.transportOptions);
    }

    public OpenSearchSearchPipelineClient searchPipeline() {
        return new OpenSearchSearchPipelineClient((OpenSearchTransport)this.transport, this.transportOptions);
    }

    public SearchShardsResponse searchShards(SearchShardsRequest request) throws IOException, OpenSearchException {
        return ((OpenSearchTransport)this.transport).performRequest(request, SearchShardsRequest._ENDPOINT, this.transportOptions);
    }

    public final SearchShardsResponse searchShards(Function<SearchShardsRequest.Builder, ObjectBuilder<SearchShardsRequest>> fn) throws IOException, OpenSearchException {
        return this.searchShards(fn.apply(new SearchShardsRequest.Builder()).build());
    }

    public final SearchShardsResponse searchShards() throws IOException, OpenSearchException {
        return this.searchShards(new SearchShardsRequest.Builder().build());
    }
}

