/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test.junit;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.URIConfigurationFactory;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.core.test.junit.ConfigurationFactoryType;
import org.apache.logging.log4j.core.test.junit.ContextSelectorType;
import org.apache.logging.log4j.core.test.junit.LegacyLoggerContextSource;
import org.apache.logging.log4j.core.test.junit.Log4jTest;
import org.apache.logging.log4j.core.test.junit.LoggerContextProvider;
import org.apache.logging.log4j.core.test.junit.LoggerContextSource;
import org.apache.logging.log4j.core.test.junit.LoggingResolvers;
import org.apache.logging.log4j.core.test.junit.ReconfigurationPolicy;
import org.apache.logging.log4j.core.test.junit.TestBinding;
import org.apache.logging.log4j.core.util.NetUtils;
import org.apache.logging.log4j.plugins.di.ConfigurableInstanceFactory;
import org.apache.logging.log4j.plugins.di.DI;
import org.apache.logging.log4j.plugins.util.ReflectionUtil;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.spi.Provider;
import org.apache.logging.log4j.util.ProviderUtil;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.ReflectionSupport;

class Log4jExtension
implements BeforeAllCallback,
BeforeEachCallback,
AfterEachCallback {
    private static final String FQCN = Log4jExtension.class.getName();
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{Log4jExtension.class});
    private static final List<String> EXTENSIONS = List.of(".xml", ".json", ".properties");

    Log4jExtension() {
    }

    public void beforeAll(ExtensionContext context) {
        Class testClass = context.getRequiredTestClass();
        if (AnnotationSupport.isAnnotated((AnnotatedElement)testClass, Log4jTest.class)) {
            ExtensionContext.Store store = context.getStore(NAMESPACE);
            DI.FactoryBuilder builder = (DI.FactoryBuilder)store.getOrComputeIfAbsent(DI.FactoryBuilder.class);
            Log4jExtension.configure(builder, store, testClass, testClass);
        }
    }

    public void beforeEach(ExtensionContext context) {
        Class testClass = context.getRequiredTestClass();
        Method testMethod = context.getRequiredTestMethod();
        ExtensionContext.Store store = context.getStore(NAMESPACE);
        if (AnnotationSupport.isAnnotated((AnnotatedElement)testMethod, Log4jTest.class)) {
            DI.FactoryBuilder builder = AnnotationSupport.isAnnotated((AnnotatedElement)testClass, Log4jTest.class) ? ((DI.FactoryBuilder)store.get(DI.FactoryBuilder.class, DI.FactoryBuilder.class)).copy() : (DI.FactoryBuilder)store.getOrComputeIfAbsent(DI.FactoryBuilder.class);
            Log4jExtension.configure(builder, store, testMethod, testClass);
        }
        AnnotationSupport.findAnnotation((AnnotatedElement)testClass, LoggerContextSource.class).map(LoggerContextSource::reconfigure).filter(ReconfigurationPolicy.BEFORE_EACH::equals).ifPresent(ignored -> Log4jExtension.getRequiredLoggerContext(store).reconfigure());
    }

    public void afterEach(ExtensionContext context) {
        AnnotationSupport.findAnnotation((Optional)context.getTestClass(), LoggerContextSource.class).map(LoggerContextSource::reconfigure).filter(ReconfigurationPolicy.AFTER_EACH::equals).ifPresent(ignored -> Log4jExtension.getRequiredLoggerContext(context).reconfigure());
    }

    private static void configure(DI.FactoryBuilder builder, ExtensionContext.Store store, AnnotatedElement element, Class<?> testClass) {
        ConfigurableInstanceFactory instanceFactory = Log4jExtension.configureInstanceFactory(builder, element);
        Provider provider = (Provider)instanceFactory.getInstance(Provider.class);
        store.put(ProviderHolder.class, (Object)new ProviderHolder(provider));
        Log4jContextFactory factory = (Log4jContextFactory)provider.getLoggerContextFactory();
        if (AnnotationSupport.isAnnotated((AnnotatedElement)element, LoggingResolvers.class)) {
            AnnotationSupport.findAnnotation((AnnotatedElement)element, LoggerContextSource.class).map(source -> Log4jExtension.configureLoggerContextSource(source, testClass, factory)).or(() -> AnnotationSupport.findAnnotation((AnnotatedElement)element, LegacyLoggerContextSource.class).map(source -> Log4jExtension.configureLegacyLoggerContextSource(source, testClass, factory))).ifPresent(p -> store.put(LoggerContextProvider.class, p));
        }
    }

    private static ConfigurableInstanceFactory configureInstanceFactory(DI.FactoryBuilder builder, AnnotatedElement element) {
        AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)element, TestBinding.class).forEach(testBinding -> Log4jExtension.registerTestBinding(builder, testBinding));
        AnnotationSupport.findAnnotation((AnnotatedElement)element, ContextSelectorType.class).map(ContextSelectorType::value).ifPresent(clazz -> builder.addInitialBindingFrom(ContextSelector.KEY).toFunction(instanceFactory -> instanceFactory.getFactory(clazz)));
        AnnotationSupport.findAnnotation((AnnotatedElement)element, ConfigurationFactoryType.class).map(ConfigurationFactoryType::value).ifPresent(clazz -> builder.addBindingFrom(URIConfigurationFactory.KEY).toFunction(instanceFactory -> instanceFactory.getFactory(clazz)));
        return builder.build();
    }

    private static void registerTestBinding(DI.FactoryBuilder builder, TestBinding testBinding) {
        Class<?> apiClass = testBinding.api();
        Class implementation = testBinding.implementation();
        String implementationClassName = testBinding.implementationClassName();
        Class implementationClass = !implementationClassName.isEmpty() ? (Class)ReflectionSupport.tryToLoadClass((String)implementationClassName).getOrThrow(e -> new IllegalArgumentException(String.format("Unable to configure test binding apiClassName=%s, implementationClassName=%s", apiClass, implementationClassName), (Throwable)e)) : implementation;
        Log4jExtension.register(builder, apiClass, implementationClass);
    }

    private static <T> void register(DI.FactoryBuilder builder, Class<T> apiClass, Class<?> implementationClass) {
        Class implementation = implementationClass.asSubclass(apiClass);
        builder.addInitialBindingFrom(apiClass).toFunction(instanceFactory -> instanceFactory.getFactory(implementation));
    }

    private static LoggerContextProvider configureLoggerContextSource(LoggerContextSource source, Class<?> testClass, Log4jContextFactory factory) {
        URI configUri;
        String configLocation = source.value();
        if (configLocation.isEmpty()) {
            URL configUrl = Log4jExtension.findTestConfiguration(testClass);
            if (configUrl != null) {
                try {
                    configUri = configUrl.toURI();
                }
                catch (URISyntaxException e) {
                    throw new ExtensionConfigurationException("Invalid configuration location", (Throwable)e);
                }
            } else {
                configUri = null;
            }
        } else {
            configUri = NetUtils.toURI((String)configLocation);
        }
        LoggerContext loggerContext = factory.getContext(FQCN, testClass.getClassLoader(), null, false, configUri, testClass.getSimpleName());
        if (loggerContext == null) {
            throw new ExtensionConfigurationException("Unable to set up LoggerContext from config URI " + configUri);
        }
        return new LoggerContextResource(loggerContext, source.timeout(), source.unit());
    }

    private static LoggerContextProvider configureLegacyLoggerContextSource(LegacyLoggerContextSource source, Class<?> testClass, Log4jContextFactory factory) {
        String configLocation = source.value();
        String configurationKey = "log4j.configuration";
        String compatibilityKey = "log4j.v1.compatibility";
        System.setProperty("log4j.configuration", configLocation);
        System.setProperty("log4j.v1.compatibility", "true");
        String contextName = testClass.getSimpleName();
        LoggerContext context = factory.getContext(FQCN, testClass.getClassLoader(), null, false, (URI)null, contextName);
        if (context == null) {
            throw new ExtensionConfigurationException("Unable to set up LoggerContext from v1 config location " + configLocation);
        }
        Runnable cleaner = () -> {
            context.close();
            System.clearProperty("log4j.configuration");
            System.clearProperty("log4j.v1.compatibility");
        };
        return new LoggerContextResource(context, cleaner);
    }

    private static URL findTestConfiguration(Class<?> testClass) {
        for (Class<?> clazz = testClass; clazz != null; clazz = clazz.getSuperclass()) {
            List<String> baseFileNames = List.of(clazz.getSimpleName(), clazz.getName().replaceAll("[.$]", "/"));
            for (String baseFileName : baseFileNames) {
                for (String extension : EXTENSIONS) {
                    URL url = clazz.getResource(baseFileName + extension);
                    if (url == null) continue;
                    return url;
                }
            }
        }
        return null;
    }

    static LoggerContext getRequiredLoggerContext(ExtensionContext context) {
        return Log4jExtension.getRequiredLoggerContext(context.getStore(NAMESPACE));
    }

    private static LoggerContext getRequiredLoggerContext(ExtensionContext.Store store) {
        LoggerContextProvider provider = (LoggerContextProvider)store.get(LoggerContextProvider.class, LoggerContextProvider.class);
        if (provider == null) {
            throw new PreconditionViolationException("Unable to find instance of " + LoggerContextProvider.class);
        }
        return provider.loggerContext();
    }

    private static final class ProviderHolder
    implements ExtensionContext.Store.CloseableResource {
        private static final Field startupLock;
        private static final Field providerField;
        private final Provider oldProvider;

        private ProviderHolder(Provider provider) {
            this.oldProvider = this.setProvider(provider);
        }

        public void close() {
            this.setProvider(this.oldProvider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Provider setProvider(Provider provider) {
            Lock lock = (Lock)ReflectionUtil.getStaticFieldValue((Field)startupLock);
            lock.lock();
            try {
                Provider oldProvider = (Provider)ReflectionUtil.getStaticFieldValue((Field)providerField);
                ReflectionUtil.setStaticFieldValue((Field)providerField, (Object)provider);
                if (provider != null) {
                    LogManager.setFactory((LoggerContextFactory)provider.getLoggerContextFactory());
                    ThreadContext.init();
                }
                Provider provider2 = oldProvider;
                return provider2;
            }
            finally {
                lock.unlock();
            }
        }

        static {
            try {
                providerField = ProviderUtil.class.getDeclaredField("PROVIDER");
                startupLock = ProviderUtil.class.getDeclaredField("STARTUP_LOCK");
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private record LoggerContextResource(LoggerContext loggerContext, Runnable cleaner) implements LoggerContextProvider,
    ExtensionContext.Store.CloseableResource
    {
        LoggerContextResource(LoggerContext loggerContext, long shutdownTimeout, TimeUnit unit) {
            this(loggerContext, () -> loggerContext.stop(shutdownTimeout, unit));
        }

        public void close() {
            this.cleaner.run();
        }
    }
}

