/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jndi.test.junit;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.NamingManager;
import org.apache.logging.log4j.jndi.JndiManager;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.osjava.sj.jndi.MemoryContext;

public class JndiRule
implements TestRule {
    private static final Hashtable<String, Object> ENV = new Hashtable<String, String>(Map.of("org.osjava.sj.jndi.ignoreClose", "true"));
    private static final Context CONTEXT = new MemoryContext(ENV);
    @Nullable
    private final String managerName;
    private final Map<String, Object> bindings;

    public JndiRule(String name, Object value) {
        this(null, Collections.singletonMap(name, value));
    }

    public JndiRule(@Nullable String managerName, String name, Object value) {
        this(managerName, Collections.singletonMap(name, value));
    }

    public JndiRule(Map<String, Object> bindings) {
        this(null, bindings);
    }

    public JndiRule(@Nullable String managerName, Map<String, Object> bindings) {
        this.managerName = managerName;
        this.bindings = Objects.requireNonNull(bindings, "bindings");
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                JndiRule.this.resetJndiManager();
                base.evaluate();
            }
        };
    }

    private void resetJndiManager() throws NamingException {
        if (JndiManager.isJndiEnabled()) {
            JndiRule.clearBindings();
            this.addBindings();
        }
    }

    private static void clearBindings() throws NamingException {
        Collections.list(CONTEXT.list("")).forEach(binding -> {
            try {
                CONTEXT.unbind(binding.getName());
            }
            catch (NamingException error) {
                throw new RuntimeException(error);
            }
        });
    }

    private void addBindings() throws NamingException {
        for (Map.Entry<String, Object> entry : this.bindings.entrySet()) {
            String key = entry.getKey();
            Object object = entry.getValue();
            JndiRule.recursiveBind(key, object);
        }
    }

    public static void recursiveBind(String key, Object value) throws NamingException {
        Name name = CONTEXT.getNameParser((Name)null).parse(key);
        Context currentContext = CONTEXT;
        int lastIndex = name.size() - 1;
        for (int i = 0; i < lastIndex; ++i) {
            try {
                currentContext = (Context)currentContext.lookup(name.get(i));
                continue;
            }
            catch (NamingException ignored) {
                currentContext = currentContext.createSubcontext(name.get(i));
            }
        }
        currentContext.bind(name.get(lastIndex), value);
    }

    public static void rebind(String key, Object value) throws NamingException {
        CONTEXT.rebind(key, value);
    }

    static {
        InitialContextFactoryBuilder factoryBuilder = factoryBuilderEnv -> factoryEnv -> CONTEXT;
        try {
            NamingManager.setInitialContextFactoryBuilder(factoryBuilder);
        }
        catch (NamingException error) {
            throw new RuntimeException(error);
        }
    }
}

