/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.ManagerException;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Cast;

public class ManagerRegistry {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final Map<String, AbstractManager> managers = new HashMap<String, AbstractManager>();
    private final Lock registryLock = new ReentrantLock();

    public boolean hasManager(String name) {
        this.registryLock.lock();
        try {
            boolean bl = this.managers.containsKey(name);
            return bl;
        }
        finally {
            this.registryLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <M extends AbstractManager, D> M getOrCreateManager(String name, ManagerFactory<M, D> factory, D data) {
        this.registryLock.lock();
        try {
            AbstractManager manager = (AbstractManager)Cast.cast((Object)this.managers.get(name));
            if (manager == null) {
                manager = (AbstractManager)factory.createManager(name, data);
                if (manager == null) {
                    String message = "Error creating manager with name '" + name + "' from ManagerFactory " + factory + " using data " + data;
                    throw new ManagerException(message);
                }
                this.managers.put(name, manager);
            } else {
                manager.updateData(data);
            }
            ++manager.count;
            AbstractManager abstractManager = manager;
            return (M)abstractManager;
        }
        finally {
            this.registryLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseManager(AbstractManager manager, long timeout, TimeUnit unit) {
        String name = manager.getName();
        this.registryLock.lock();
        try {
            if (--manager.count <= 0 && this.removeManager(name, manager)) {
                String simpleName = manager.getClass().getSimpleName();
                LOGGER.debug("Shutting down {} {}", (Object)simpleName, (Object)name);
                boolean stopped = manager.releaseSub(timeout, unit);
                LOGGER.debug("Shut down {} {}, all resources released: {}", (Object)simpleName, (Object)name, (Object)stopped);
                boolean bl = stopped;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.registryLock.unlock();
        }
    }

    boolean removeManager(String name, AbstractManager manager) {
        return this.managers.remove(name, manager);
    }
}

