/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.composite.CompositeConfiguration;
import org.apache.logging.log4j.core.impl.ContextAnchor;
import org.apache.logging.log4j.core.impl.CoreProperties;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.core.util.Cancellable;
import org.apache.logging.log4j.core.util.ShutdownCallbackRegistry;
import org.apache.logging.log4j.kit.env.PropertyEnvironment;
import org.apache.logging.log4j.plugins.Inject;
import org.apache.logging.log4j.plugins.Singleton;
import org.apache.logging.log4j.plugins.di.ConfigurableInstanceFactory;
import org.apache.logging.log4j.plugins.di.DI;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Constants;
import org.apache.logging.log4j.util.StackLocatorUtil;
import org.jspecify.annotations.NullMarked;

@Singleton
public class Log4jContextFactory
implements LoggerContextFactory,
ShutdownCallbackRegistry {
    private static final StatusLogger LOGGER = StatusLogger.getLogger();
    private static final Key<LoggerContextFactory> KEY = Key.builder(LoggerContextFactory.class).get();
    private final ContextSelector selector;
    private final ShutdownCallbackRegistry shutdownCallbackRegistry;

    public Log4jContextFactory() {
        this(DI.createInitializedFactory());
    }

    @NullMarked
    public Log4jContextFactory(ContextSelector selector) {
        this(DI.builder().addInitialBindingFrom(ContextSelector.KEY).toInstance((Object)selector).build());
    }

    @NullMarked
    public Log4jContextFactory(ShutdownCallbackRegistry shutdownCallbackRegistry) {
        this(DI.builder().addInitialBindingFrom(ShutdownCallbackRegistry.KEY).toInstance((Object)shutdownCallbackRegistry).build());
    }

    @NullMarked
    public Log4jContextFactory(ContextSelector selector, ShutdownCallbackRegistry shutdownCallbackRegistry) {
        this(DI.builder().addInitialBindingFrom(ContextSelector.KEY).toInstance((Object)selector).addInitialBindingFrom(ShutdownCallbackRegistry.KEY).toInstance((Object)shutdownCallbackRegistry).build());
    }

    @Inject
    @NullMarked
    public Log4jContextFactory(ConfigurableInstanceFactory instanceFactory) {
        instanceFactory.registerBinding(KEY, () -> this);
        this.selector = (ContextSelector)instanceFactory.getInstance(ContextSelector.KEY);
        this.shutdownCallbackRegistry = (ShutdownCallbackRegistry)instanceFactory.getInstance(ShutdownCallbackRegistry.KEY);
        LOGGER.debug("Using ShutdownCallbackRegistry {}", this.shutdownCallbackRegistry.getClass());
        this.initializeShutdownCallbackRegistry();
    }

    private void initializeShutdownCallbackRegistry() {
        if (this.isShutdownHookEnabled() && this.shutdownCallbackRegistry instanceof LifeCycle) {
            try {
                ((LifeCycle)((Object)this.shutdownCallbackRegistry)).start();
            }
            catch (IllegalStateException e) {
                LOGGER.error("Cannot start ShutdownCallbackRegistry, already shutting down.");
                throw e;
            }
            catch (RuntimeException e) {
                LOGGER.error("There was an error starting the ShutdownCallbackRegistry.", (Throwable)e);
            }
        }
    }

    public LoggerContext getContext(String fqcn, ClassLoader loader, Object externalContext, boolean currentContext) {
        ClassLoader classLoader = loader != null ? loader : StackLocatorUtil.getCallerClass((String)fqcn).getClassLoader();
        LoggerContext ctx = this.selector.getContext(fqcn, classLoader, currentContext);
        if (externalContext != null && ctx.getExternalContext() == null) {
            ctx.setExternalContext(externalContext);
        }
        if (ctx.getState() == LifeCycle.State.INITIALIZED) {
            this.startContext(ctx, classLoader);
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggerContext getContext(String fqcn, ClassLoader loader, Object externalContext, boolean currentContext, ConfigurationSource source) {
        ClassLoader classLoader = loader != null ? loader : StackLocatorUtil.getCallerClass((String)fqcn).getClassLoader();
        LoggerContext ctx = this.selector.getContext(fqcn, classLoader, currentContext, null);
        if (externalContext != null && ctx.getExternalContext() == null) {
            ctx.setExternalContext(externalContext);
        }
        if (ctx.getState() == LifeCycle.State.INITIALIZED) {
            if (source != null) {
                ContextAnchor.THREAD_CONTEXT.set(ctx);
                try {
                    Configuration config = ctx.getConfiguration(source);
                    LOGGER.debug("Starting {} from configuration {}", (Object)ctx, (Object)source);
                    ctx.start(config);
                }
                finally {
                    ContextAnchor.THREAD_CONTEXT.remove();
                }
            } else {
                this.startContext(ctx, classLoader);
            }
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggerContext getContext(String fqcn, ClassLoader loader, Object externalContext, boolean currentContext, Configuration configuration) {
        ClassLoader classLoader = loader != null ? loader : StackLocatorUtil.getCallerClass((String)fqcn).getClassLoader();
        LoggerContext ctx = this.selector.getContext(fqcn, classLoader, currentContext, null);
        if (externalContext != null && ctx.getExternalContext() == null) {
            ctx.setExternalContext(externalContext);
        }
        if (ctx.getState() == LifeCycle.State.INITIALIZED) {
            ContextAnchor.THREAD_CONTEXT.set(ctx);
            try {
                ctx.start(configuration);
            }
            finally {
                ContextAnchor.THREAD_CONTEXT.remove();
            }
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggerContext getContext(String fqcn, ClassLoader loader, Object externalContext, boolean currentContext, URI configLocation, String name) {
        ClassLoader classLoader = loader != null ? loader : StackLocatorUtil.getCallerClass((String)fqcn).getClassLoader();
        LoggerContext ctx = this.selector.getContext(fqcn, classLoader, currentContext, configLocation);
        if (externalContext != null && ctx.getExternalContext() == null) {
            ctx.setExternalContext(externalContext);
        }
        if (name != null) {
            ctx.setName(name);
        }
        if (ctx.getState() == LifeCycle.State.INITIALIZED) {
            if (configLocation != null || name != null) {
                ContextAnchor.THREAD_CONTEXT.set(ctx);
                try {
                    Configuration config = ctx.getConfiguration(name, configLocation);
                    LOGGER.debug("Starting {} from configuration at {}", (Object)ctx, (Object)configLocation);
                    ctx.start(config);
                }
                finally {
                    ContextAnchor.THREAD_CONTEXT.remove();
                }
            } else {
                this.startContext(ctx, classLoader);
            }
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggerContext getContext(String fqcn, ClassLoader loader, Map.Entry<String, Object> entry, boolean currentContext, URI configLocation, String name) {
        ClassLoader classLoader = loader != null ? loader : StackLocatorUtil.getCallerClass((String)fqcn).getClassLoader();
        LoggerContext ctx = this.selector.getContext(fqcn, classLoader, entry, currentContext, configLocation);
        if (name != null) {
            ctx.setName(name);
        }
        if (ctx.getState() == LifeCycle.State.INITIALIZED) {
            if (configLocation != null || name != null) {
                try {
                    ContextAnchor.THREAD_CONTEXT.set(ctx);
                    Configuration config = ctx.getConfiguration(name, configLocation);
                    LOGGER.debug("Starting {} from configuration at {}", (Object)ctx, (Object)configLocation);
                    ctx.start(config);
                }
                finally {
                    ContextAnchor.THREAD_CONTEXT.remove();
                }
            } else {
                this.startContext(ctx, classLoader);
            }
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggerContext getContext(String fqcn, ClassLoader loader, Object externalContext, boolean currentContext, List<URI> configLocations, String name) {
        ClassLoader classLoader = loader != null ? loader : StackLocatorUtil.getCallerClass((String)fqcn).getClassLoader();
        LoggerContext ctx = this.selector.getContext(fqcn, classLoader, currentContext, null);
        if (externalContext != null && ctx.getExternalContext() == null) {
            ctx.setExternalContext(externalContext);
        }
        if (name != null) {
            ctx.setName(name);
        }
        if (ctx.getState() == LifeCycle.State.INITIALIZED) {
            if (configLocations != null && !configLocations.isEmpty()) {
                ContextAnchor.THREAD_CONTEXT.set(ctx);
                try {
                    ArrayList<AbstractConfiguration> configurations = new ArrayList<AbstractConfiguration>(configLocations.size());
                    for (URI configLocation : configLocations) {
                        Configuration currentReadConfiguration = ctx.getConfiguration(name, configLocation);
                        if (currentReadConfiguration != null) {
                            if (currentReadConfiguration instanceof DefaultConfiguration) {
                                LOGGER.warn("Unable to locate configuration {}, ignoring", (Object)configLocation.toString());
                                continue;
                            }
                            if (currentReadConfiguration instanceof AbstractConfiguration) {
                                configurations.add((AbstractConfiguration)currentReadConfiguration);
                                continue;
                            }
                            LOGGER.error("Found configuration {}, which is not an AbstractConfiguration and can't be handled by CompositeConfiguration", (Object)configLocation);
                            continue;
                        }
                        LOGGER.info("Unable to access configuration {}, ignoring", (Object)configLocation.toString());
                    }
                    if (configurations.isEmpty()) {
                        LOGGER.error("No configurations could be created for {}", (Object)configLocations.toString());
                    }
                    if (configurations.size() == 1) {
                        ctx.start((Configuration)configurations.get(0));
                    }
                    ctx.start(new CompositeConfiguration(ctx, configurations));
                }
                finally {
                    ContextAnchor.THREAD_CONTEXT.remove();
                }
            } else {
                this.startContext(ctx, classLoader);
            }
        }
        return ctx;
    }

    private void startContext(LoggerContext ctx, ClassLoader classLoader) {
        Configuration config = ctx.getConfiguration(ctx.getName(), null);
        if (config != null) {
            ctx.start(config);
        } else {
            ctx.start();
        }
    }

    public void shutdown(String fqcn, ClassLoader loader, boolean currentContext, boolean allContexts) {
        if (this.selector.hasContext(fqcn, loader, currentContext)) {
            this.selector.shutdown(fqcn, loader, currentContext, allContexts);
        }
    }

    public boolean hasContext(String fqcn, ClassLoader loader, boolean currentContext) {
        return this.selector.hasContext(fqcn, loader, currentContext);
    }

    public ContextSelector getSelector() {
        return this.selector;
    }

    public ShutdownCallbackRegistry getShutdownCallbackRegistry() {
        return this.shutdownCallbackRegistry;
    }

    public void removeContext(org.apache.logging.log4j.spi.LoggerContext context) {
        if (context instanceof LoggerContext) {
            this.selector.removeContext((LoggerContext)context);
        }
    }

    public boolean isClassLoaderDependent() {
        return this.selector.isClassLoaderDependent();
    }

    @Override
    public Cancellable addShutdownCallback(Runnable callback) {
        return this.isShutdownHookEnabled() ? this.shutdownCallbackRegistry.addShutdownCallback(callback) : null;
    }

    public boolean isShutdownHookEnabled() {
        Boolean shutdownHookEnabled = ((CoreProperties.LoggerContextProperties)PropertyEnvironment.getGlobal().getProperty(CoreProperties.LoggerContextProperties.class)).shutdownHookEnabled();
        return shutdownHookEnabled != null ? shutdownHookEnabled : !Constants.IS_WEB_APP;
    }
}

