/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.ConfigurationAware;
import org.apache.logging.log4j.core.config.LoggerContextAware;
import org.apache.logging.log4j.core.lookup.AbstractConfigurationAwareLookup;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;

public class Interpolator
extends AbstractConfigurationAwareLookup
implements LoggerContextAware {
    public static final char PREFIX_SEPARATOR = ':';
    private static final String LOOKUP_KEY_WEB = "web";
    private static final String LOOKUP_KEY_DOCKER = "docker";
    private static final String LOOKUP_KEY_KUBERNETES = "kubernetes";
    private static final String LOOKUP_KEY_SPRING = "spring";
    private static final String LOOKUP_KEY_JNDI = "jndi";
    private static final String LOOKUP_KEY_JVMRUNARGS = "jvmrunargs";
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final Map<String, Supplier<? extends StrLookup>> strLookups = new ConcurrentHashMap<String, Supplier<? extends StrLookup>>();
    private final StrLookup defaultLookup;
    private WeakReference<LoggerContext> loggerContext = null;

    public Interpolator(StrLookup defaultLookup, Map<String, Supplier<StrLookup>> additionalLookups) {
        this.defaultLookup = defaultLookup;
        this.strLookups.putAll(additionalLookups);
    }

    public StrLookup getDefaultLookup() {
        return this.defaultLookup;
    }

    private void handleError(String lookupKey, Throwable t) {
        switch (lookupKey) {
            case "jndi": {
                LOGGER.warn("JNDI lookup class is not available because this JRE does not support JNDI. JNDI string lookups will not be available, continuing configuration. Ignoring " + t);
                break;
            }
            case "jvmrunargs": {
                LOGGER.warn("JMX runtime input lookup class is not available because this JRE does not support JMX. JMX lookups will not be available, continuing configuration. Ignoring " + t);
                break;
            }
            case "web": {
                LOGGER.info("Log4j appears to be running in a Servlet environment, but there's no `log4j-jakarta-web` module available. If you want better web container support, please add the `log4j-jakarta-web` JAR to your web archive or server lib directory.");
                break;
            }
            case "docker": 
            case "spring": {
                break;
            }
            case "kubernetes": {
                if (!(t instanceof NoClassDefFoundError)) break;
                LOGGER.warn("Unable to create Kubernetes lookup due to missing dependency: {}", (Object)t.getMessage());
                break;
            }
            default: {
                LOGGER.error("Unable to create Lookup for {}", (Object)lookupKey, (Object)t);
            }
        }
    }

    @Override
    public String lookup(LogEvent event, String var) {
        if (var == null) {
            return null;
        }
        int prefixPos = var.indexOf(58);
        if (prefixPos >= 0) {
            String prefix = Strings.toRootLowerCase((String)var.substring(0, prefixPos));
            String name = var.substring(prefixPos + 1);
            Supplier<? extends StrLookup> lookupSupplier = this.strLookups.get(prefix);
            String value = null;
            if (lookupSupplier != null) {
                StrLookup lookup = lookupSupplier.get();
                if (lookup instanceof ConfigurationAware) {
                    ((ConfigurationAware)((Object)lookup)).setConfiguration(this.configuration);
                }
                if (lookup instanceof LoggerContextAware) {
                    ((LoggerContextAware)((Object)lookup)).setLoggerContext((LoggerContext)this.loggerContext.get());
                }
                if (lookup != null) {
                    String string = value = event == null ? lookup.lookup(name) : lookup.lookup(event, name);
                }
            }
            if (value != null) {
                return value;
            }
            var = var.substring(prefixPos + 1);
        }
        if (this.defaultLookup != null) {
            return event == null ? this.defaultLookup.lookup(var) : this.defaultLookup.lookup(event, var);
        }
        return null;
    }

    @Override
    public void setLoggerContext(LoggerContext loggerContext) {
        if (loggerContext == null) {
            return;
        }
        this.loggerContext = new WeakReference<LoggerContext>(loggerContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String name : this.strLookups.keySet()) {
            if (sb.length() == 0) {
                sb.append('{');
            } else {
                sb.append(", ");
            }
            sb.append(name);
        }
        if (sb.length() > 0) {
            sb.append('}');
        }
        return sb.toString();
    }
}

