/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.time;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.impl.CoreProperties;
import org.apache.logging.log4j.core.time.Clock;
import org.apache.logging.log4j.core.time.PreciseClock;
import org.apache.logging.log4j.core.time.internal.CachedClock;
import org.apache.logging.log4j.core.time.internal.CoarseCachedClock;
import org.apache.logging.log4j.core.time.internal.SystemClock;
import org.apache.logging.log4j.core.time.internal.SystemMillisClock;
import org.apache.logging.log4j.kit.env.PropertyEnvironment;
import org.apache.logging.log4j.plugins.SingletonFactory;
import org.apache.logging.log4j.plugins.condition.ConditionalOnMissingBinding;
import org.apache.logging.log4j.plugins.di.DI;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Lazy;

public final class ClockFactory {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final Lazy<Clock> FALLBACK = Lazy.lazy(() -> (Clock)DI.builder().build().getInstance(Clock.KEY));

    @Deprecated
    public static Clock getClock() {
        return (Clock)FALLBACK.get();
    }

    @ConditionalOnMissingBinding
    @SingletonFactory
    @Deprecated(forRemoval=true)
    public Clock clock(PropertyEnvironment environment) {
        CoreProperties.ConfigurationProperties configuration = (CoreProperties.ConfigurationProperties)environment.getProperty(CoreProperties.ConfigurationProperties.class);
        if (configuration.clock() == null) {
            return ClockFactory.logSupportedPrecision(new SystemClock());
        }
        return switch (configuration.clock()) {
            case "SystemMillisClock" -> ClockFactory.logSupportedPrecision(new SystemMillisClock());
            case "CachedClock", "org.apache.logging.log4j.core.time.internal.CachedClock" -> ClockFactory.logSupportedPrecision(CachedClock.instance());
            case "CoarseCachedClock", "org.apache.logging.log4j.core.time.internal.CoarseCachedClock" -> ClockFactory.logSupportedPrecision(CoarseCachedClock.instance());
            default -> ClockFactory.logSupportedPrecision(new SystemClock());
        };
    }

    private static Clock logSupportedPrecision(Clock clock) {
        String support = clock instanceof PreciseClock ? "supports" : "does not support";
        LOGGER.debug("{} {} precise timestamps.", (Object)clock.getClass().getName(), (Object)support);
        return clock;
    }
}

