/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.time.internal;

import java.time.Clock;
import java.time.Instant;
import org.apache.logging.log4j.core.impl.CoreProperties;
import org.apache.logging.log4j.core.time.MutableInstant;
import org.apache.logging.log4j.core.time.PreciseClock;
import org.apache.logging.log4j.kit.env.PropertyEnvironment;

public final class SystemClock
implements PreciseClock {
    private final boolean usePreciseClock = ((CoreProperties.ConfigurationProperties)PropertyEnvironment.getGlobal().getProperty(CoreProperties.ConfigurationProperties.class)).usePreciseClock();

    @Override
    public long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public void init(MutableInstant mutableInstant) {
        if (this.usePreciseClock) {
            Instant instant = Clock.systemUTC().instant();
            mutableInstant.initFromEpochSecond(instant.getEpochSecond(), instant.getNano());
        } else {
            mutableInstant.initFromEpochMilli(System.currentTimeMillis(), 0);
        }
    }
}

