/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.async.logger.internal;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.TimeoutException;
import com.lmax.disruptor.WaitStrategy;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TimeoutBlockingWaitStrategy
implements WaitStrategy {
    private final Lock mutex = new ReentrantLock();
    private final Condition condition = this.mutex.newCondition();
    private final long timeoutInNanos;

    public TimeoutBlockingWaitStrategy(long timeout, TimeUnit units) {
        this.timeoutInNanos = units.toNanos(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long waitFor(long sequence, Sequence cursorSequence, Sequence dependentSequence, SequenceBarrier barrier) throws AlertException, InterruptedException, TimeoutException {
        long availableSequence;
        long timeoutNanos = this.timeoutInNanos;
        if (cursorSequence.get() < sequence) {
            this.mutex.lock();
            try {
                while (cursorSequence.get() < sequence) {
                    barrier.checkAlert();
                    if ((timeoutNanos = this.condition.awaitNanos(timeoutNanos)) > 0L) continue;
                    throw TimeoutException.INSTANCE;
                }
            }
            finally {
                this.mutex.unlock();
            }
        }
        while ((availableSequence = dependentSequence.get()) < sequence) {
            barrier.checkAlert();
        }
        return availableSequence;
    }

    public void signalAllWhenBlocking() {
        this.mutex.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.mutex.unlock();
        }
    }

    public String toString() {
        return "TimeoutBlockingWaitStrategy{mutex=" + this.mutex + ", timeoutInNanos=" + this.timeoutInNanos + "}";
    }
}

