/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.storedobj.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNameConstraintViolationException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStorageException;
import org.apache.chemistry.opencmis.inmemory.ConfigurationSettings;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Content;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Document;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.DocumentVersion;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Fileable;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Folder;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.MultiFiling;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.ObjectStore;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Relationship;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoredObject;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.VersionedDocument;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.ContentStreamDataImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.DocumentImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.FolderImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.InMemoryAce;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.InMemoryAcl;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.ItemImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.Permission;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.PolicyImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.RelationshipImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.RenditionUtil;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.StoredObjectImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.VersionedDocumentImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStoreImpl
implements ObjectStore {
    private static final Logger LOG = LoggerFactory.getLogger((String)ObjectStoreImpl.class.getName());
    private static final int FIRST_ID = 100;
    private static final Long MAX_CONTENT_SIZE_KB = ConfigurationSettings.getConfigurationValueAsLong("InMemoryServer.MaxContentSizeKB");
    public static final String ADMIN_PRINCIPAL_ID = "Admin";
    private static int nextUnusedId = 100;
    private final Map<String, StoredObject> fStoredObjectMap = new ConcurrentHashMap<String, StoredObject>();
    private int nextUnusedAclId = 0;
    private final List<InMemoryAcl> fAcls = new ArrayList<InMemoryAcl>();
    private final Lock fLock = new ReentrantLock();
    private final String fRepositoryId;
    private FolderImpl fRootFolder = null;

    public ObjectStoreImpl(String repositoryId) {
        this.fRepositoryId = repositoryId;
        this.createRootFolder();
    }

    private static synchronized Integer getNextId() {
        return nextUnusedId++;
    }

    private synchronized Integer getNextAclId() {
        return this.nextUnusedAclId++;
    }

    private void lock() {
        this.fLock.lock();
    }

    private void unlock() {
        this.fLock.unlock();
    }

    @Override
    public Folder getRootFolder() {
        return this.fRootFolder;
    }

    @Override
    public StoredObject getObjectByPath(String path, String user) {
        Fileable so = this.findObjectWithPathInDescendents(path, user, "/", this.fRootFolder);
        return so;
    }

    private Fileable findObjectWithPathInDescendents(String path, String user, String prefix, Fileable fo) {
        if (path.equals(prefix)) {
            return fo;
        }
        if (fo instanceof Folder) {
            List<Fileable> children = this.getChildren((Folder)fo);
            for (Fileable child : children) {
                Fileable found;
                String foundPath = prefix.length() == 1 ? prefix + child.getName() : prefix + "/" + child.getName();
                if (!path.startsWith(foundPath) || null == (found = this.findObjectWithPathInDescendents(path, user, foundPath, child))) continue;
                return found;
            }
        }
        return null;
    }

    @Override
    public StoredObject getObjectById(String objectId) {
        StoredObject so = this.fStoredObjectMap.get(objectId);
        return so;
    }

    @Override
    public void deleteObject(String objectId, Boolean allVersions, String user) {
        StoredObject obj = this.fStoredObjectMap.get(objectId);
        if (null == obj) {
            throw new CmisObjectNotFoundException("Cannot delete object with id  " + objectId + ". Object does not exist.");
        }
        if (obj instanceof FolderImpl) {
            this.deleteFolder(objectId, user);
        } else if (obj instanceof DocumentVersion) {
            boolean otherVersionsExists;
            DocumentVersion vers = (DocumentVersion)obj;
            VersionedDocument parentDoc = vers.getParentDocument();
            if (allVersions != null && allVersions.booleanValue()) {
                otherVersionsExists = false;
                List<DocumentVersion> allVers = parentDoc.getAllVersions();
                for (DocumentVersion ver : allVers) {
                    this.fStoredObjectMap.remove(ver.getId());
                }
            } else {
                this.fStoredObjectMap.remove(objectId);
                otherVersionsExists = parentDoc.deleteVersion(vers);
            }
            if (!otherVersionsExists) {
                this.fStoredObjectMap.remove(parentDoc.getId());
            }
        } else {
            this.fStoredObjectMap.remove(objectId);
        }
    }

    public String storeObject(StoredObject so) {
        String id = so.getId();
        if (null == id) {
            id = ObjectStoreImpl.getNextId().toString();
        }
        this.fStoredObjectMap.put(id, so);
        return id;
    }

    StoredObject getObject(String id) {
        return this.fStoredObjectMap.get(id);
    }

    void removeObject(String id) {
        this.fStoredObjectMap.remove(id);
    }

    public Set<String> getIds() {
        Set<String> entries = this.fStoredObjectMap.keySet();
        return entries;
    }

    @Override
    public void clear() {
        this.lock();
        this.fStoredObjectMap.clear();
        this.storeObject(this.fRootFolder);
        this.unlock();
    }

    @Override
    public long getObjectCount() {
        return this.fStoredObjectMap.size();
    }

    private void createRootFolder() {
        FolderImpl rootFolder = new FolderImpl();
        rootFolder.setName("RootFolder");
        rootFolder.setParentId(null);
        rootFolder.setTypeId(BaseTypeId.CMIS_FOLDER.value());
        rootFolder.setCreatedBy(ADMIN_PRINCIPAL_ID);
        rootFolder.setModifiedBy(ADMIN_PRINCIPAL_ID);
        rootFolder.setModifiedAtNow();
        rootFolder.setRepositoryId(this.fRepositoryId);
        rootFolder.setAclId(this.addAcl(InMemoryAcl.getDefaultAcl()));
        String id = this.storeObject(rootFolder);
        rootFolder.setId(id);
        this.fRootFolder = rootFolder;
    }

    @Override
    public Document createDocument(Map<String, PropertyData<?>> propMap, String user, Folder folder, ContentStream contentStream, List<String> policies, Acl addACEs, Acl removeACEs) {
        String name = (String)propMap.get("cmis:name").getFirstValue();
        DocumentImpl doc = new DocumentImpl();
        doc.createSystemBasePropertiesWhenCreated(propMap, user);
        doc.setCustomProperties(propMap);
        doc.setRepositoryId(this.fRepositoryId);
        doc.setName(name);
        if (null != folder) {
            if (this.hasChild(folder, name)) {
                throw new CmisNameConstraintViolationException("Cannot create document an object with name " + name + " already exists in folder " + this.getFolderPath(folder.getId()));
            }
            doc.addParentId(folder.getId());
        }
        ContentStream content = this.setContent(doc, contentStream);
        doc.setContent(content);
        int aclId = this.getAclId((FolderImpl)folder, addACEs, removeACEs);
        doc.setAclId(aclId);
        if (null != policies) {
            doc.setAppliedPolicies(policies);
        }
        String id = this.storeObject(doc);
        doc.setId(id);
        this.applyAcl(doc, addACEs, removeACEs);
        return doc;
    }

    @Override
    public StoredObject createItem(String name, Map<String, PropertyData<?>> propMap, String user, Folder folder, List<String> policies, Acl addACEs, Acl removeACEs) {
        ItemImpl item = new ItemImpl();
        item.createSystemBasePropertiesWhenCreated(propMap, user);
        item.setCustomProperties(propMap);
        item.setRepositoryId(this.fRepositoryId);
        item.setName(name);
        if (null != folder) {
            if (this.hasChild(folder, name)) {
                throw new CmisNameConstraintViolationException("Cannot create document an object with name " + name + " already exists in folder " + this.getFolderPath(folder.getId()));
            }
            item.addParentId(folder.getId());
        }
        if (null != policies) {
            item.setAppliedPolicies(policies);
        }
        int aclId = this.getAclId((FolderImpl)folder, addACEs, removeACEs);
        item.setAclId(aclId);
        String id = this.storeObject(item);
        item.setId(id);
        this.applyAcl(item, addACEs, removeACEs);
        return item;
    }

    @Override
    public DocumentVersion createVersionedDocument(String name, Map<String, PropertyData<?>> propMap, String user, Folder folder, List<String> policies, Acl addACEs, Acl removeACEs, ContentStream contentStream, VersioningState versioningState) {
        VersionedDocumentImpl doc = new VersionedDocumentImpl();
        doc.createSystemBasePropertiesWhenCreated(propMap, user);
        doc.setCustomProperties(propMap);
        doc.setRepositoryId(this.fRepositoryId);
        doc.setName(name);
        String id = this.storeObject(doc);
        doc.setId(id);
        DocumentVersion version = doc.addVersion(versioningState, user);
        this.setContent(version, contentStream);
        version.createSystemBasePropertiesWhenCreated(propMap, user);
        version.setCustomProperties(propMap);
        if (null != folder) {
            if (this.hasChild(folder, name)) {
                throw new CmisNameConstraintViolationException("Cannot create document an object with name " + name + " already exists in folder " + this.getFolderPath(folder.getId()));
            }
            doc.addParentId(folder.getId());
        }
        int aclId = this.getAclId((FolderImpl)folder, addACEs, removeACEs);
        doc.setAclId(aclId);
        if (null != policies) {
            doc.setAppliedPolicies(policies);
        }
        id = this.storeObject(version);
        version.setId(id);
        this.applyAcl(doc, addACEs, removeACEs);
        return version;
    }

    @Override
    public Folder createFolder(String name, Map<String, PropertyData<?>> propMap, String user, Folder parent, List<String> policies, Acl addACEs, Acl removeACEs) {
        if (null == parent) {
            throw new CmisInvalidArgumentException("Cannot create root folder.");
        }
        if (this.hasChild(parent, name)) {
            throw new CmisNameConstraintViolationException("Cannot create folder, this name already exists in parent folder.");
        }
        FolderImpl folder = new FolderImpl(name, parent.getId());
        if (null != propMap) {
            folder.createSystemBasePropertiesWhenCreated(propMap, user);
            folder.setCustomProperties(propMap);
        }
        folder.setRepositoryId(this.fRepositoryId);
        int aclId = this.getAclId((FolderImpl)parent, addACEs, removeACEs);
        folder.setAclId(aclId);
        if (null != policies) {
            folder.setAppliedPolicies(policies);
        }
        String id = this.storeObject(folder);
        folder.setId(id);
        this.applyAcl(folder, addACEs, removeACEs);
        return folder;
    }

    public Folder createFolder(String name) {
        FolderImpl folder = new FolderImpl(name, null);
        folder.setRepositoryId(this.fRepositoryId);
        return folder;
    }

    @Override
    public StoredObject createPolicy(String name, String policyText, Map<String, PropertyData<?>> propMap, String user, Acl addACEs, Acl removeACEs) {
        PolicyImpl policy = new PolicyImpl();
        policy.createSystemBasePropertiesWhenCreated(propMap, user);
        policy.setCustomProperties(propMap);
        policy.setRepositoryId(this.fRepositoryId);
        policy.setName(name);
        policy.setPolicyText(policyText);
        String id = this.storeObject(policy);
        policy.setId(id);
        this.applyAcl(policy, addACEs, removeACEs);
        return policy;
    }

    @Override
    public StoredObject createRelationship(String name, StoredObject sourceObject, StoredObject targetObject, Map<String, PropertyData<?>> propMap, String user, Acl addACEs, Acl removeACEs) {
        RelationshipImpl rel = new RelationshipImpl();
        rel.createSystemBasePropertiesWhenCreated(propMap, user);
        rel.setCustomProperties(propMap);
        rel.setRepositoryId(this.fRepositoryId);
        rel.setName(name);
        if (null != sourceObject) {
            rel.setSource(sourceObject.getId());
        }
        if (null != targetObject) {
            rel.setTarget(targetObject.getId());
        }
        String id = this.storeObject(rel);
        rel.setId(id);
        this.applyAcl(rel, addACEs, removeACEs);
        return rel;
    }

    @Override
    public void storeVersion(DocumentVersion version) {
        String id = this.storeObject(version);
        version.setId(id);
    }

    @Override
    public void deleteVersion(DocumentVersion version) {
        StoredObject found = this.fStoredObjectMap.remove(version.getId());
        if (null == found) {
            throw new CmisInvalidArgumentException("Cannot delete object with id  " + version.getId() + ". Object does not exist.");
        }
    }

    @Override
    public void updateObject(StoredObject so, Map<String, PropertyData<?>> newProperties, String user) {
        Map<String, PropertyData<?>> properties = so.getProperties();
        for (String key : newProperties.keySet()) {
            PropertyData<?> value = newProperties.get(key);
            if (key.equals("cmis:secondaryObjectTypeIds")) {
                properties.put(key, value);
                continue;
            }
            if (null == value || value.getValues() == null || value.getFirstValue() == null) {
                properties.remove(key);
                continue;
            }
            properties.put(key, value);
        }
        so.updateSystemBasePropertiesWhenModified(properties, user);
        properties.remove("cmis:secondaryObjectTypeIds");
    }

    @Override
    public List<StoredObject> getCheckedOutDocuments(String orderBy, String user, IncludeRelationships includeRelationships) {
        ArrayList<StoredObject> res = new ArrayList<StoredObject>();
        for (StoredObject so : this.fStoredObjectMap.values()) {
            VersionedDocument verDoc;
            if (!(so instanceof VersionedDocument) || !(verDoc = (VersionedDocument)so).isCheckedOut() || !this.hasReadAccess(user, verDoc)) continue;
            res.add(verDoc.getPwc());
        }
        return res;
    }

    @Override
    public List<StoredObject> getRelationships(String objectId, List<String> typeIds, RelationshipDirection direction) {
        ArrayList<StoredObject> res = new ArrayList();
        if (typeIds != null && typeIds.size() > 0) {
            for (String typeId : typeIds) {
                for (StoredObject so : this.fStoredObjectMap.values()) {
                    if (!(so instanceof Relationship) || !so.getTypeId().equals(typeId)) continue;
                    Relationship ro = (Relationship)((Object)so);
                    if (ro.getSourceObjectId().equals(objectId) && (RelationshipDirection.EITHER == direction || RelationshipDirection.SOURCE == direction)) {
                        res.add(so);
                        continue;
                    }
                    if (!ro.getTargetObjectId().equals(objectId) || RelationshipDirection.EITHER != direction && RelationshipDirection.TARGET != direction) continue;
                    res.add(so);
                }
            }
        } else {
            res = this.getAllRelationships(objectId, direction);
        }
        return res;
    }

    @Override
    public String getFolderPath(String folderId) {
        StringBuilder sb = new StringBuilder();
        this.insertPathSegment(sb, folderId);
        return sb.toString();
    }

    private void insertPathSegment(StringBuilder sb, String folderId) {
        Folder folder = (Folder)this.getObjectById(folderId);
        if (null == folder.getParentId()) {
            if (sb.length() == 0) {
                sb.insert(0, "/");
            }
        } else {
            sb.insert(0, folder.getName());
            sb.insert(0, "/");
            this.insertPathSegment(sb, folder.getParentId());
        }
    }

    @Override
    public Acl applyAcl(StoredObject so, Acl addAces, Acl removeAces, AclPropagation aclPropagation, String principalId) {
        if (aclPropagation == AclPropagation.OBJECTONLY || !(so instanceof Folder)) {
            return this.applyAcl(so, addAces, removeAces);
        }
        return this.applyAclRecursive((Folder)so, addAces, removeAces, principalId);
    }

    @Override
    public Acl applyAcl(StoredObject so, Acl acl, AclPropagation aclPropagation, String principalId) {
        if (aclPropagation == AclPropagation.OBJECTONLY || !(so instanceof Folder)) {
            return this.applyAcl(so, acl);
        }
        return this.applyAclRecursive((Folder)so, acl, principalId);
    }

    public List<Integer> getAllAclsForUser(String principalId, Permission permission) {
        ArrayList<Integer> acls = new ArrayList<Integer>();
        for (InMemoryAcl acl : this.fAcls) {
            if (!acl.hasPermission(principalId, permission)) continue;
            acls.add(acl.getId());
        }
        return acls;
    }

    @Override
    public Acl getAcl(int aclId) {
        InMemoryAcl acl = this.getInMemoryAcl(aclId);
        return acl == null ? InMemoryAcl.getDefaultAcl().toCommonsAcl() : acl.toCommonsAcl();
    }

    public int getAclId(StoredObjectImpl so, Acl addACEs, Acl removeACEs) {
        InMemoryAce inMemAce;
        InMemoryAcl newAcl;
        boolean removeDefaultAcl = false;
        int aclId = 0;
        newAcl = so == null ? new InMemoryAcl() : (null == (newAcl = this.getInMemoryAcl(aclId = so.getAclId())) ? new InMemoryAcl() : new InMemoryAcl(newAcl.getAces()));
        if (newAcl.size() == 0 && addACEs == null && removeACEs == null) {
            return 0;
        }
        if (null != removeACEs) {
            for (Ace ace : removeACEs.getAces()) {
                inMemAce = new InMemoryAce(ace);
                if (!inMemAce.equals(InMemoryAce.getDefaultAce())) continue;
                removeDefaultAcl = true;
            }
        }
        if (so != null && 0 == aclId && !removeDefaultAcl) {
            return 0;
        }
        if (null != addACEs) {
            for (Ace ace : addACEs.getAces()) {
                inMemAce = new InMemoryAce(ace);
                if (inMemAce.equals(InMemoryAce.getDefaultAce())) {
                    return 0;
                }
                newAcl.addAce(inMemAce);
            }
        }
        if (null != removeACEs) {
            for (Ace ace : removeACEs.getAces()) {
                inMemAce = new InMemoryAce(ace);
                newAcl.removeAce(inMemAce);
            }
        }
        if (newAcl.size() > 0) {
            return this.addAcl(newAcl);
        }
        return 0;
    }

    private void deleteFolder(String folderId, String user) {
        StoredObject folder = this.fStoredObjectMap.get(folderId);
        if (folder == null) {
            throw new CmisInvalidArgumentException("Unknown object with id:  " + folderId);
        }
        if (!(folder instanceof FolderImpl)) {
            throw new CmisInvalidArgumentException("Cannot delete folder with id:  " + folderId + ". Object exists but is not a folder.");
        }
        List<Fileable> children = this.getChildren((Folder)folder, -1, -1, user, true).getChildren();
        if (children != null && !children.isEmpty()) {
            throw new CmisConstraintException("Cannot delete folder with id:  " + folderId + ". Folder is not empty.");
        }
        this.fStoredObjectMap.remove(folderId);
    }

    @Override
    public ObjectStore.ChildrenResult getChildren(Folder folder, int maxItemsParam, int skipCountParam, String user, boolean usePwc) {
        List<Fileable> children = this.getChildren(folder, user, usePwc);
        ObjectStoreImpl.sortFolderList(children);
        int maxItems = maxItemsParam < 0 ? children.size() : maxItemsParam;
        int skipCount = skipCountParam < 0 ? 0 : skipCountParam;
        int from = Math.min(skipCount, children.size());
        int to = Math.min(maxItems + from, children.size());
        int noItems = children.size();
        children = children.subList(from, to);
        return new ObjectStore.ChildrenResult(children, noItems);
    }

    private List<Fileable> getChildren(Folder folder) {
        return this.getChildren(folder, null, false);
    }

    private List<Fileable> getChildren(Folder folder, String user, boolean usePwc) {
        ArrayList<Fileable> children = new ArrayList<Fileable>();
        for (String id : this.getIds()) {
            StoredObject obj = this.getObject(id);
            if (!(obj instanceof Fileable)) continue;
            Fileable pathObj = (Fileable)obj;
            if (null != user && !this.hasReadAccess(user, obj) || !pathObj.getParentIds().contains(folder.getId())) continue;
            if (pathObj instanceof VersionedDocument) {
                DocumentVersion ver;
                if (usePwc) {
                    ver = ((VersionedDocument)((Object)pathObj)).getPwc();
                    if (null == ver) {
                        ver = ((VersionedDocument)((Object)pathObj)).getLatestVersion(false);
                    }
                } else {
                    ver = ((VersionedDocument)((Object)pathObj)).getLatestVersion(false);
                }
                children.add(ver);
                continue;
            }
            if (pathObj instanceof DocumentVersion) continue;
            children.add(pathObj);
        }
        return children;
    }

    @Override
    public ObjectStore.ChildrenResult getFolderChildren(Folder folder, int maxItems, int skipCount, String user) {
        ArrayList<Fileable> folderChildren = new ArrayList();
        for (String id : this.getIds()) {
            Folder childFolder;
            StoredObject obj = this.getObject(id);
            if (!this.hasReadAccess(user, obj) || !(obj instanceof Folder) || !(childFolder = (Folder)obj).getParentIds().contains(folder.getId())) continue;
            folderChildren.add(childFolder);
        }
        ObjectStoreImpl.sortFolderList(folderChildren);
        int from = Math.min(skipCount, folderChildren.size());
        int to = Math.min(maxItems + from, folderChildren.size());
        int noItems = folderChildren.size();
        folderChildren = folderChildren.subList(from, to);
        return new ObjectStore.ChildrenResult(folderChildren, noItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(StoredObject so, Folder oldParent, Folder newParent, String user) {
        try {
            if (this.hasChild(newParent, so.getName())) {
                throw new CmisInvalidArgumentException("Cannot move object " + so.getName() + " to folder " + this.getFolderPath(newParent.getId()) + ". A child with this name already exists.");
            }
            this.lock();
            if (so instanceof MultiFiling) {
                MultiFiling fi = (MultiFiling)((Object)so);
                this.addParentIntern(fi, newParent);
                this.removeParentIntern(fi, oldParent);
            } else if (so instanceof FolderImpl) {
                ((FolderImpl)so).setParentId(newParent.getId());
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(StoredObject so, String newName, String user) {
        try {
            this.lock();
            if (so.getId().equals(this.fRootFolder.getId())) {
                throw new CmisInvalidArgumentException("Root folder cannot be renamed.");
            }
            if (so.getName().equals(newName)) {
                return;
            }
            if (so instanceof Fileable) {
                for (String folderId : ((Fileable)so).getParentIds()) {
                    Folder folder = (Folder)this.getObjectById(folderId);
                    if (!this.hasChild(folder, newName)) continue;
                    throw new CmisNameConstraintViolationException("Cannot rename object to " + newName + ". This path already exists in parent " + this.getFolderPath(folder.getId()) + ".");
                }
            }
            so.setName(newName);
        }
        finally {
            this.unlock();
        }
    }

    private boolean hasChild(Folder folder, String name) {
        List<Fileable> children = this.getChildren(folder);
        for (Fileable child : children) {
            if (!child.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getParentIds(StoredObject so, String user) {
        ArrayList<String> visibleParents = new ArrayList<String>();
        if (!(so instanceof Fileable)) {
            throw new CmisInvalidArgumentException("Object is not fileable: " + so.getId());
        }
        Fileable fileable = (Fileable)so;
        List<String> parents = fileable.getParentIds();
        for (String id : parents) {
            StoredObject parent = this.getObjectById(id);
            if (!this.hasReadAccess(user, parent)) continue;
            visibleParents.add(id);
        }
        return visibleParents;
    }

    public boolean hasReadAccess(String principalId, StoredObject so) {
        return this.hasAccess(principalId, so, Permission.READ);
    }

    public boolean hasWriteAccess(String principalId, StoredObject so) {
        return this.hasAccess(principalId, so, Permission.WRITE);
    }

    public boolean hasAllAccess(String principalId, StoredObject so) {
        return this.hasAccess(principalId, so, Permission.ALL);
    }

    public void checkReadAccess(String principalId, StoredObject so) {
        this.checkAccess(principalId, so, Permission.READ);
    }

    public void checkWriteAccess(String principalId, StoredObject so) {
        this.checkAccess(principalId, so, Permission.WRITE);
    }

    public void checkAllAccess(String principalId, StoredObject so) {
        this.checkAccess(principalId, so, Permission.ALL);
    }

    private void checkAccess(String principalId, StoredObject so, Permission permission) {
        if (!this.hasAccess(principalId, so, permission)) {
            throw new CmisPermissionDeniedException("Object with id " + so.getId() + " and name " + so.getName() + " does not grant " + permission.toString() + " access to principal " + principalId);
        }
    }

    private boolean hasAccess(String principalId, StoredObject so, Permission permission) {
        if (null != principalId && principalId.equals(ADMIN_PRINCIPAL_ID)) {
            return true;
        }
        List<Integer> aclIds = this.getAllAclsForUser(principalId, permission);
        return aclIds.contains(((StoredObjectImpl)so).getAclId());
    }

    private InMemoryAcl getInMemoryAcl(int aclId) {
        for (InMemoryAcl acl : this.fAcls) {
            if (aclId != acl.getId()) continue;
            return acl;
        }
        return null;
    }

    private int setAcl(StoredObjectImpl so, Acl acl) {
        int aclId = null == acl || acl.getAces().isEmpty() ? 0 : this.getAclId(null, acl, null);
        so.setAclId(aclId);
        return aclId;
    }

    private int hasAcl(InMemoryAcl acl) {
        for (InMemoryAcl acl2 : this.fAcls) {
            if (!acl2.equals(acl)) continue;
            return acl2.getId();
        }
        return -1;
    }

    private int addAcl(InMemoryAcl acl) {
        int aclId = -1;
        if (null == acl) {
            return 0;
        }
        this.lock();
        try {
            aclId = this.hasAcl(acl);
            if (aclId < 0) {
                aclId = this.getNextAclId();
                acl.setId(aclId);
                this.fAcls.add(acl);
            }
        }
        finally {
            this.unlock();
        }
        return aclId;
    }

    private Acl applyAcl(StoredObject so, Acl acl) {
        int aclId = this.setAcl((StoredObjectImpl)so, acl);
        return this.getAcl(aclId);
    }

    private Acl applyAcl(StoredObject so, Acl addAces, Acl removeAces) {
        int aclId = this.getAclId((StoredObjectImpl)so, addAces, removeAces);
        ((StoredObjectImpl)so).setAclId(aclId);
        return this.getAcl(aclId);
    }

    private Acl applyAclRecursive(Folder folder, Acl addAces, Acl removeAces, String principalId) {
        List<Fileable> children = this.getChildren(folder, -1, -1, ADMIN_PRINCIPAL_ID, false).getChildren();
        Acl result = this.applyAcl(folder, addAces, removeAces);
        if (null == children) {
            return result;
        }
        for (Fileable child : children) {
            if (!this.hasAllAccess(principalId, child)) continue;
            if (child instanceof Folder) {
                this.applyAclRecursive((Folder)child, addAces, removeAces, principalId);
                continue;
            }
            this.applyAcl(child, addAces, removeAces);
        }
        return result;
    }

    private Acl applyAclRecursive(Folder folder, Acl acl, String principalId) {
        List<Fileable> children = this.getChildren(folder, -1, -1, ADMIN_PRINCIPAL_ID, false).getChildren();
        Acl result = this.applyAcl(folder, acl);
        if (null == children) {
            return result;
        }
        for (Fileable child : children) {
            if (!this.hasAllAccess(principalId, child)) continue;
            if (child instanceof Folder) {
                this.applyAclRecursive((Folder)child, acl, principalId);
                continue;
            }
            this.applyAcl(child, acl);
        }
        return result;
    }

    private List<StoredObject> getAllRelationships(String objectId, RelationshipDirection direction) {
        ArrayList<StoredObject> res = new ArrayList<StoredObject>();
        for (StoredObject so : this.fStoredObjectMap.values()) {
            if (!(so instanceof Relationship)) continue;
            Relationship ro = (Relationship)((Object)so);
            if (ro.getSourceObjectId().equals(objectId) && (RelationshipDirection.EITHER == direction || RelationshipDirection.SOURCE == direction)) {
                res.add(so);
                continue;
            }
            if (!ro.getTargetObjectId().equals(objectId) || RelationshipDirection.EITHER != direction && RelationshipDirection.TARGET != direction) continue;
            res.add(so);
        }
        return res;
    }

    @Override
    public boolean isTypeInUse(String typeId) {
        for (String objectId : this.getIds()) {
            StoredObject so = this.getObjectById(objectId);
            if (!so.getTypeId().equals(typeId)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addParent(StoredObject so, Folder parent) {
        try {
            this.lock();
            if (this.hasChild(parent, so.getName())) {
                throw new IllegalArgumentException("Cannot assign new parent folder, this name already exists in target folder.");
            }
            if (!(so instanceof MultiFiling)) {
                throw new IllegalArgumentException("Object " + so.getId() + "is not fileable");
            }
            MultiFiling mfi = (MultiFiling)((Object)so);
            this.addParentIntern(mfi, parent);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeParent(StoredObject so, Folder parent) {
        try {
            this.lock();
            if (!(so instanceof MultiFiling)) {
                throw new IllegalArgumentException("Object " + so.getId() + "is not fileable");
            }
            MultiFiling mfi = (MultiFiling)((Object)so);
            this.removeParentIntern(mfi, parent);
        }
        finally {
            this.unlock();
        }
    }

    private void addParentIntern(MultiFiling so, Folder parent) {
        so.addParentId(parent.getId());
    }

    private void removeParentIntern(MultiFiling so, Folder parent) {
        so.removeParentId(parent.getId());
    }

    private static void sortFolderList(List<? extends StoredObject> list) {
        class FolderComparator
        implements Comparator<StoredObject> {
            FolderComparator() {
            }

            @Override
            public int compare(StoredObject f1, StoredObject f2) {
                String segment1 = f1.getName();
                String segment2 = f2.getName();
                return segment1.compareTo(segment2);
            }
        }
        Collections.sort(list, new FolderComparator());
    }

    @Override
    public ContentStream getContent(StoredObject so, long offset, long length) {
        if (so instanceof Content) {
            Content content = (Content)((Object)so);
            ContentStream contentStream = content.getContent();
            if (null == contentStream) {
                return null;
            }
            if (offset <= 0L && length < 0L) {
                return contentStream;
            }
            return ((ContentStreamDataImpl)contentStream).getCloneWithLimits(offset, length);
        }
        throw new CmisInvalidArgumentException("Cannot set content, object does not implement interface Content.");
    }

    @Override
    public ContentStream setContent(StoredObject so, ContentStream contentStream) {
        if (so instanceof Content) {
            ContentStreamDataImpl newContent;
            Content content = (Content)((Object)so);
            if (null == contentStream) {
                newContent = null;
            } else {
                boolean useFakeContentStore = so.getTypeId().equals("BigContentFakeType");
                newContent = new ContentStreamDataImpl(MAX_CONTENT_SIZE_KB == null ? 0L : MAX_CONTENT_SIZE_KB, useFakeContentStore);
                String fileName = contentStream.getFileName();
                if (null == fileName || fileName.length() <= 0) {
                    fileName = so.getName();
                }
                newContent.setFileName(fileName);
                String mimeType = contentStream.getMimeType();
                if (null == mimeType || mimeType.length() <= 0) {
                    mimeType = "application/octet-stream";
                }
                newContent.setMimeType(mimeType);
                newContent.setLastModified(new GregorianCalendar());
                try {
                    newContent.setContent(contentStream.getStream());
                }
                catch (IOException e) {
                    throw new CmisRuntimeException("Failed to get content from InputStream", (Throwable)e);
                }
            }
            content.setContent((ContentStream)newContent);
            return newContent;
        }
        throw new CmisInvalidArgumentException("Cannot set content, object does not implement interface Content.");
    }

    @Override
    public void appendContent(StoredObject so, ContentStream contentStream) {
        if (so instanceof Content) {
            Content content = (Content)((Object)so);
            ContentStreamDataImpl newContent = (ContentStreamDataImpl)content.getContent();
            if (null == newContent) {
                content.setContent(null);
            } else {
                try {
                    newContent.appendContent(contentStream.getStream());
                }
                catch (IOException e) {
                    throw new CmisStorageException("Failed to append content: IO Exception", (Throwable)e);
                }
            }
        } else {
            throw new CmisInvalidArgumentException("Cannot set content, object does not implement interface Content.");
        }
    }

    @Override
    public List<RenditionData> getRenditions(StoredObject so, String renditionFilter, long maxItems, long skipCount) {
        return RenditionUtil.getRenditions(so, renditionFilter, maxItems, skipCount);
    }

    @Override
    public ContentStream getRenditionContent(StoredObject so, String streamId, long offset, long length) {
        return RenditionUtil.getRenditionContent(so, streamId, offset, length);
    }
}

