/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import org.h2.store.fs.FileObject;

public class FileObjectDiskChannel
implements FileObject {
    private final String name;
    private final RandomAccessFile file;
    private final FileChannel channel;
    private FileLock lock;
    private long length;

    FileObjectDiskChannel(String string, String string2) throws IOException {
        this.name = string;
        this.file = new RandomAccessFile(string, string2);
        this.channel = this.file.getChannel();
        this.length = this.file.length();
    }

    public void close() throws IOException {
        this.channel.close();
        this.file.close();
    }

    public long getFilePointer() throws IOException {
        return this.channel.position();
    }

    public String getName() {
        return "nio:" + this.name;
    }

    public long length() throws IOException {
        return this.channel.size();
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        if (this.channel.position() + (long)n2 > this.length) {
            throw new EOFException();
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.position(n);
        byteBuffer.limit(n + n2);
        this.channel.read(byteBuffer);
    }

    public void seek(long l) throws IOException {
        this.channel.position(l);
    }

    public void setFileLength(long l) throws IOException {
        if (l <= this.channel.size()) {
            long l2 = this.channel.position();
            try {
                this.channel.truncate(l);
            }
            catch (NonWritableChannelException nonWritableChannelException) {
                throw new IOException("read only");
            }
            if (l2 > l) {
                l2 = l;
            }
            this.channel.position(l2);
        } else {
            ByteBuffer byteBuffer = ByteBuffer.allocate(1);
            this.channel.write(byteBuffer, l - 1L);
        }
        this.length = l;
    }

    public void sync() throws IOException {
        this.channel.force(true);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.position(n);
        byteBuffer.limit(n + n2);
        try {
            this.channel.write(byteBuffer);
        }
        catch (NonWritableChannelException nonWritableChannelException) {
            throw new IOException("read only");
        }
    }

    public synchronized boolean tryLock() {
        if (this.lock == null) {
            try {
                this.lock = this.channel.tryLock();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.lock != null;
        }
        return false;
    }

    public synchronized void releaseLock() {
        if (this.lock != null) {
            try {
                this.lock.release();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.lock = null;
        }
    }
}

