/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class OptimizeStrings {
    private int splitSize = 0x7FFFFFFD;
    private ArrayList<String> inStrings = new ArrayList();
    private Map<String, Integer> stringToIndexMap;
    private int[] offsets;
    private String[] commonStringsA;
    private int[] lastIndexInCommonStringsA;
    private Map<String, String> returnedStrings = new HashMap<String, String>();
    private long savedCharsExact = 0L;
    private long savedCharsSubstr = 0L;
    private int nextSeq = -1;
    private final boolean doMeasurement;

    public OptimizeStrings(boolean doMeasurement) {
        this.doMeasurement = doMeasurement;
    }

    public OptimizeStrings(boolean doMeasurement, int splitSize) {
        this.doMeasurement = doMeasurement;
        this.splitSize = splitSize;
    }

    public long getSavedCharsExact() {
        return this.savedCharsExact;
    }

    public long getSavedCharsSubstr() {
        return this.savedCharsSubstr;
    }

    public String[] getCommonStrings() {
        return this.commonStringsA;
    }

    public void add(String s) {
        if (this.inStrings.size() == 0x7FFFFFFE) {
            throw new RuntimeException(String.format("Exceeded size limit, size = %,d%n", this.inStrings.size()));
        }
        if (null != s) {
            this.inStrings.add(s);
        }
    }

    public void add(String[] sa) {
        if (null != sa) {
            for (String s : sa) {
                this.add(s);
            }
        }
    }

    public int getStringIndex(String s) {
        if (null == s) {
            return -1;
        }
        return this.stringToIndexMap.get(s);
    }

    public int getIndexOrSeqIndex(String s) {
        if (null == s) {
            throw new RuntimeException();
        }
        int v = this.stringToIndexMap.get(s);
        if (v >= 0) {
            this.stringToIndexMap.put(s, this.nextSeq--);
        }
        return v;
    }

    public String getString(String s) {
        if (null == s) {
            return null;
        }
        int i = this.getStringIndex(s);
        int offset = this.getOffset(i);
        String r = this.commonStringsA[this.getCommonStringIndex(i)].substring(offset, offset + s.length());
        String rs = this.returnedStrings.get(r);
        if (null != rs) {
            return rs;
        }
        this.returnedStrings.put(r, r);
        return r;
    }

    public long getOffset(String s) {
        if (null == s) {
            return -1L;
        }
        return this.offsets[this.getStringIndex(s)];
    }

    public int getOffset(int i) {
        return this.offsets[i];
    }

    public int getCommonStringIndex(int index) {
        for (int i = 0; i < this.lastIndexInCommonStringsA.length; ++i) {
            if (index < this.lastIndexInCommonStringsA[i]) continue;
            return i;
        }
        throw new IllegalArgumentException("index out of range, must be >= 0, was " + index);
    }

    public String[] getStringArray(String[] sai) {
        if (null == sai) {
            return null;
        }
        String[] sa = new String[sai.length];
        for (int i = 0; i < sai.length; ++i) {
            sa[i] = this.getString(sai[i]);
        }
        return sa;
    }

    public void updateStringArray(String[] sa) {
        if (null == sa) {
            return;
        }
        for (int i = 0; i < sa.length; ++i) {
            sa[i] = this.getString(sa[i]);
        }
    }

    public void optimize() {
        String[] sa = this.inStrings.toArray(new String[this.inStrings.size()]);
        this.optimizeI(sa);
        this.inStrings = new ArrayList();
    }

    private void optimizeI(String[] sortedStrings) {
        int i;
        int ssLength;
        this.savedCharsExact = 0L;
        this.savedCharsSubstr = 0L;
        StringBuilder sb = new StringBuilder();
        String[] sortedStrings2 = this.sortStrings(sortedStrings);
        if (sortedStrings2 != sortedStrings) {
            ssLength = sortedStrings2.length;
            sortedStrings = sortedStrings2;
        } else {
            ssLength = this.eliminateSortedStringDuplicates(sortedStrings);
        }
        String previous = "";
        int previousOffset = 0;
        this.offsets = new int[ssLength];
        ArrayList<Integer> lastIndexInCommonStrings = new ArrayList<Integer>();
        ArrayList<String> commonStrings = new ArrayList<String>();
        for (i = ssLength - 1; i >= 0; --i) {
            String s = sortedStrings[i];
            int sLength = s.length();
            if (sLength > this.splitSize) {
                throw new RuntimeException(String.format("String too long, length = %,d, max length allowed is %,d", sLength, this.splitSize));
            }
            if (previous.startsWith(s)) {
                this.offsets[i] = previousOffset;
                if (!this.doMeasurement) continue;
                this.savedCharsSubstr += (long)sLength;
                continue;
            }
            if (sb.length() + sLength > this.splitSize) {
                commonStrings.add(sb.toString());
                sb = new StringBuilder();
                lastIndexInCommonStrings.add(i + 1);
            }
            this.offsets[i] = previousOffset = sb.length();
            previous = s;
            sb.append(previous);
        }
        commonStrings.add(sb.toString());
        lastIndexInCommonStrings.add(0);
        this.lastIndexInCommonStringsA = new int[lastIndexInCommonStrings.size()];
        for (i = 0; i < lastIndexInCommonStrings.size(); ++i) {
            this.lastIndexInCommonStringsA[i] = (Integer)lastIndexInCommonStrings.get(i);
        }
        this.commonStringsA = commonStrings.toArray(new String[commonStrings.size()]);
        this.stringToIndexMap = new HashMap<String, Integer>(ssLength);
        for (i = ssLength - 1; i >= 0; --i) {
            this.stringToIndexMap.put(sortedStrings[i], i);
        }
    }

    private int eliminateSortedStringDuplicates(String[] sortedStrings) {
        if (sortedStrings.length == 0) {
            return 0;
        }
        String prev = sortedStrings[0];
        int to = 1;
        for (int from = 1; from < sortedStrings.length; ++from) {
            String s = sortedStrings[from];
            if (s.equals(prev)) {
                if (!this.doMeasurement) continue;
                this.savedCharsExact += (long)s.length();
                continue;
            }
            prev = s;
            sortedStrings[to] = s;
            ++to;
        }
        return to;
    }

    private String[] sortStrings(String[] sa) {
        try {
            Arrays.sort(sa);
            return sa;
        }
        catch (StackOverflowError e) {
            TreeSet<String> orderedSet = new TreeSet<String>();
            for (String s : this.inStrings) {
                if (orderedSet.add(s)) continue;
                this.savedCharsExact += (long)s.length();
            }
            sa = new String[orderedSet.size()];
            Iterator it = orderedSet.iterator();
            for (int i = 0; i < sa.length; ++i) {
                sa[i] = (String)it.next();
            }
            return sa;
        }
    }
}

