/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import org.opensaml.MalformedException;
import org.opensaml.SAMLException;
import org.opensaml.SAMLStatement;
import org.opensaml.SAMLSubject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class SAMLSubjectStatement
extends SAMLStatement
implements Cloneable {
    protected SAMLSubject subject = null;

    protected SAMLSubjectStatement() {
    }

    protected SAMLSubjectStatement(SAMLSubject sAMLSubject) throws SAMLException {
        this.subject = (SAMLSubject)sAMLSubject.setParent(this);
    }

    protected SAMLSubjectStatement(Element element) throws SAMLException {
        this.fromDOM(element);
    }

    protected SAMLSubjectStatement(InputStream inputStream) throws SAMLException {
        this.fromDOM(SAMLSubjectStatement.fromStream(inputStream));
    }

    public void fromDOM(Element element) throws SAMLException {
        super.fromDOM(element);
        this.subject = (SAMLSubject)new SAMLSubject(XML.getFirstChildElement(element)).setParent(this);
    }

    public SAMLSubject getSubject() {
        return this.subject;
    }

    public void setSubject(SAMLSubject sAMLSubject) throws SAMLException {
        if (sAMLSubject == null) {
            throw new IllegalArgumentException("subject cannot be null");
        }
        this.subject = (SAMLSubject)sAMLSubject.setParent(this);
        this.setDirty(true);
    }

    public Node toDOM(Document document, boolean bl) throws SAMLException {
        super.toDOM(document, bl);
        if (this.dirty) {
            ((Element)this.root).appendChild(this.subject.toDOM(document, false));
        }
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        if (this.subject == null) {
            throw new MalformedException(SAMLException.RESPONDER, "SubjectStatement invalid, requires subject");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLSubjectStatement sAMLSubjectStatement = (SAMLSubjectStatement)super.clone();
        try {
            sAMLSubjectStatement.subject = (SAMLSubject)((SAMLSubject)this.subject.clone()).setParent(sAMLSubjectStatement);
        }
        catch (SAMLException sAMLException) {
            throw new CloneNotSupportedException(sAMLException.getMessage());
        }
        return sAMLSubjectStatement;
    }
}

