/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities;

import org.apache.manifoldcf.authorities.BaseDomainsInitializationCommand;
import org.apache.manifoldcf.authorities.interfaces.IAuthorizationDomainManager;
import org.apache.manifoldcf.authorities.system.Logging;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class UnRegisterDomain
extends BaseDomainsInitializationCommand {
    public static final String _rcsid = "@(#)$Id: UnRegisterDomain.java 1536144 2013-10-27 14:27:39Z kwright $";
    private final String domainName;

    public UnRegisterDomain(String domainName) {
        this.domainName = domainName;
    }

    @Override
    protected void doExecute(IAuthorizationDomainManager mgr) throws ManifoldCFException {
        mgr.unregisterDomain(this.domainName);
        Logging.root.info((Object)("Successfully unregistered domain '" + this.domainName + "'"));
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: UnRegisterDomain <domainname>");
            System.exit(1);
        }
        String domainName = args[0];
        try {
            UnRegisterDomain unRegisterDomain = new UnRegisterDomain(domainName);
            unRegisterDomain.execute();
            System.err.println("Successfully unregistered domain '" + domainName + "'");
        }
        catch (ManifoldCFException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

