/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.method;

import java.lang.reflect.Method;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.RootClassFilter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class PrefixBasedMethodMatcher
implements MethodMatcher,
Pointcut {
    private static final ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private final ClassFilter classFilter;
    private final String methodPrefix;

    PrefixBasedMethodMatcher(Class<?> javaType, String methodPrefix) {
        this.classFilter = new RootClassFilter(javaType);
        this.methodPrefix = methodPrefix;
    }

    static PrefixBasedMethodMatcher fromClass(String className, String method) {
        int lastDotIndex = method.lastIndexOf(".");
        Assert.isTrue((lastDotIndex != -1 || StringUtils.hasText((String)className) ? 1 : 0) != 0, () -> "'" + method + "' is not a valid method name: format is FQN.methodName");
        if (lastDotIndex == -1) {
            Class javaType = ClassUtils.resolveClassName((String)className, (ClassLoader)beanClassLoader);
            return new PrefixBasedMethodMatcher(javaType, method);
        }
        String methodName = method.substring(lastDotIndex + 1);
        Assert.hasText((String)methodName, () -> "Method not found for '" + method + "'");
        String typeName = method.substring(0, lastDotIndex);
        Class javaType = ClassUtils.resolveClassName((String)typeName, (ClassLoader)beanClassLoader);
        return new PrefixBasedMethodMatcher(javaType, method);
    }

    public ClassFilter getClassFilter() {
        return this.classFilter;
    }

    public MethodMatcher getMethodMatcher() {
        return this;
    }

    public boolean matches(Method method, Class<?> targetClass) {
        return this.matches(this.methodPrefix, method.getName());
    }

    public boolean isRuntime() {
        return false;
    }

    public boolean matches(Method method, Class<?> targetClass, Object ... args) {
        return this.matches(this.methodPrefix, method.getName());
    }

    private boolean matches(String mappedName, String methodName) {
        boolean equals = methodName.equals(mappedName);
        return equals || this.prefixMatches(mappedName, methodName) || this.suffixMatches(mappedName, methodName);
    }

    private boolean prefixMatches(String mappedName, String methodName) {
        return mappedName.endsWith("*") && methodName.startsWith(mappedName.substring(0, mappedName.length() - 1));
    }

    private boolean suffixMatches(String mappedName, String methodName) {
        return mappedName.startsWith("*") && methodName.endsWith(mappedName.substring(1));
    }
}

