/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flow;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Set;
import org.apache.nifi.flow.ComponentType;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedRemoteGroupPort;

public class VersionedRemoteProcessGroup
extends VersionedComponent {
    private String targetUris;
    private String communicationsTimeout;
    private String yieldDuration;
    private String transportProtocol;
    private String localNetworkInterface;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUser;
    private String proxyPassword;
    private Set<VersionedRemoteGroupPort> inputPorts;
    private Set<VersionedRemoteGroupPort> outputPorts;

    @Schema(description="The target URIs of the remote process group. If target uris is not set but target uri is set, then returns the single target uri. If neither target uris nor target uri is set, then returns null.")
    public String getTargetUris() {
        return !this.isEmpty(this.targetUris) ? this.targetUris : null;
    }

    private boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public void setTargetUris(String targetUris) {
        this.targetUris = targetUris;
    }

    @Schema(description="The time period used for the timeout when communicating with the target.")
    public String getCommunicationsTimeout() {
        return this.communicationsTimeout;
    }

    public void setCommunicationsTimeout(String communicationsTimeout) {
        this.communicationsTimeout = communicationsTimeout;
    }

    @Schema(description="When yielding, this amount of time must elapse before the remote process group is scheduled again.")
    public String getYieldDuration() {
        return this.yieldDuration;
    }

    public void setYieldDuration(String yieldDuration) {
        this.yieldDuration = yieldDuration;
    }

    @Schema(description="The Transport Protocol that is used for Site-to-Site communications. Possible returned values: RAW, HTTP.")
    public String getTransportProtocol() {
        return this.transportProtocol;
    }

    public void setTransportProtocol(String transportProtocol) {
        this.transportProtocol = transportProtocol;
    }

    @Schema(description="A Set of Input Ports that can be connected to, in order to send data to the remote NiFi instance")
    public Set<VersionedRemoteGroupPort> getInputPorts() {
        return this.inputPorts;
    }

    public void setInputPorts(Set<VersionedRemoteGroupPort> inputPorts) {
        this.inputPorts = inputPorts;
    }

    @Schema(description="A Set of Output Ports that can be connected to, in order to pull data from the remote NiFi instance")
    public Set<VersionedRemoteGroupPort> getOutputPorts() {
        return this.outputPorts;
    }

    public void setOutputPorts(Set<VersionedRemoteGroupPort> outputPorts) {
        this.outputPorts = outputPorts;
    }

    @Schema(description="The local network interface to send/receive data. If not specified, any local address is used. If clustered, all nodes must have an interface with this identifier.")
    public String getLocalNetworkInterface() {
        return this.localNetworkInterface;
    }

    public void setLocalNetworkInterface(String localNetworkInterface) {
        this.localNetworkInterface = localNetworkInterface;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentType.REMOTE_PROCESS_GROUP;
    }
}

