/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import java.util.function.Supplier;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.context.ApplicationContext;
import org.springframework.expression.EvaluationContext;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.authorization.method.ExpressionAttribute;
import org.springframework.security.authorization.method.ExpressionUtils;
import org.springframework.security.authorization.method.MethodAuthorizationDeniedHandler;
import org.springframework.security.authorization.method.MethodInvocationResult;
import org.springframework.security.authorization.method.PostAuthorizeExpressionAttribute;
import org.springframework.security.authorization.method.PostAuthorizeExpressionAttributeRegistry;
import org.springframework.security.authorization.method.PrePostTemplateDefaults;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.annotation.AnnotationTemplateExpressionDefaults;

public final class PostAuthorizeAuthorizationManager
implements AuthorizationManager<MethodInvocationResult>,
MethodAuthorizationDeniedHandler {
    private PostAuthorizeExpressionAttributeRegistry registry = new PostAuthorizeExpressionAttributeRegistry();

    public void setExpressionHandler(MethodSecurityExpressionHandler expressionHandler) {
        this.registry.setExpressionHandler(expressionHandler);
    }

    @Deprecated
    public void setTemplateDefaults(PrePostTemplateDefaults defaults) {
        this.registry.setTemplateDefaults(defaults);
    }

    public void setTemplateDefaults(AnnotationTemplateExpressionDefaults defaults) {
        this.registry.setTemplateDefaults(defaults);
    }

    public void setApplicationContext(ApplicationContext context) {
        this.registry.setApplicationContext(context);
    }

    @Override
    public AuthorizationDecision check(Supplier<Authentication> authentication, MethodInvocationResult mi) {
        Object attribute = this.registry.getAttribute(mi.getMethodInvocation());
        if (attribute == ExpressionAttribute.NULL_ATTRIBUTE) {
            return null;
        }
        MethodSecurityExpressionHandler expressionHandler = this.registry.getExpressionHandler();
        EvaluationContext ctx = expressionHandler.createEvaluationContext(authentication, mi.getMethodInvocation());
        expressionHandler.setReturnObject(mi.getResult(), ctx);
        return (AuthorizationDecision)ExpressionUtils.evaluate(((ExpressionAttribute)attribute).getExpression(), ctx);
    }

    @Override
    public Object handleDeniedInvocation(MethodInvocation methodInvocation, AuthorizationResult authorizationResult) {
        Object attribute = this.registry.getAttribute(methodInvocation);
        PostAuthorizeExpressionAttribute postAuthorizeAttribute = (PostAuthorizeExpressionAttribute)attribute;
        return postAuthorizeAttribute.getHandler().handleDeniedInvocation(methodInvocation, authorizationResult);
    }

    @Override
    public Object handleDeniedInvocationResult(MethodInvocationResult methodInvocationResult, AuthorizationResult authorizationResult) {
        Object attribute = this.registry.getAttribute(methodInvocationResult.getMethodInvocation());
        PostAuthorizeExpressionAttribute postAuthorizeAttribute = (PostAuthorizeExpressionAttribute)attribute;
        return postAuthorizeAttribute.getHandler().handleDeniedInvocationResult(methodInvocationResult, authorizationResult);
    }
}

