/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.csrf;

import org.springframework.core.log.LogMessage;
import org.springframework.security.web.server.csrf.CsrfToken;
import org.springframework.security.web.server.csrf.ServerCsrfTokenRequestHandlerLoggerHolder;
import org.springframework.security.web.server.csrf.ServerCsrfTokenRequestResolver;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@FunctionalInterface
public interface ServerCsrfTokenRequestHandler
extends ServerCsrfTokenRequestResolver {
    public void handle(ServerWebExchange var1, Mono<CsrfToken> var2);

    @Override
    default public Mono<String> resolveCsrfTokenValue(ServerWebExchange exchange, CsrfToken csrfToken) {
        Assert.notNull((Object)exchange, (String)"exchange cannot be null");
        Assert.notNull((Object)csrfToken, (String)"csrfToken cannot be null");
        String headerName = csrfToken.getHeaderName();
        String parameterName = csrfToken.getParameterName();
        return exchange.getFormData().flatMap(data -> {
            String token = (String)data.getFirst((Object)parameterName);
            if (token != null) {
                return Mono.just((Object)token);
            }
            ServerCsrfTokenRequestHandlerLoggerHolder.logger.trace((Object)LogMessage.format((String)"Did not find a CSRF token in the [%s] request parameter", (Object)parameterName));
            return Mono.empty();
        }).switchIfEmpty(Mono.defer(() -> {
            String token = exchange.getRequest().getHeaders().getFirst(headerName);
            if (token != null) {
                return Mono.just((Object)token);
            }
            ServerCsrfTokenRequestHandlerLoggerHolder.logger.trace((Object)LogMessage.format((String)"Did not find a CSRF token in the [%s] request header", (Object)headerName));
            return Mono.empty();
        }));
    }
}

