/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.PrintStream;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshotMetadata;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;
import org.apache.nifi.web.api.entity.VersionedFlowSnapshotMetadataSetEntity;

public class RegistryFlowVersionsResult
extends AbstractWritableResult<VersionedFlowSnapshotMetadataSetEntity> {
    final VersionedFlowSnapshotMetadataSetEntity flowVersionsEntity;

    public RegistryFlowVersionsResult(ResultType resultType, VersionedFlowSnapshotMetadataSetEntity flowVersionsEntity) {
        super(resultType);
        this.flowVersionsEntity = Objects.requireNonNull(flowVersionsEntity);
    }

    @Override
    public VersionedFlowSnapshotMetadataSetEntity getResult() {
        return this.flowVersionsEntity;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) {
        Set flowVersions = this.flowVersionsEntity.getVersionedFlowSnapshotMetadataSet();
        if (flowVersions == null || flowVersions.isEmpty()) {
            return;
        }
        List<RegisteredFlowSnapshotMetadata> flowVersionsMetadata = flowVersions.stream().map(fv -> fv.getVersionedFlowSnapshotMetadata()).sorted(Comparator.comparingLong(RegisteredFlowSnapshotMetadata::getTimestamp)).toList();
        String datePattern = "%1$ta, %<tb %<td %<tY %<tR %<tZ";
        int dateLength = String.format("%1$ta, %<tb %<td %<tY %<tR %<tZ", new Date()).length();
        Table table = new Table.Builder().column("#", 3, 3, false).column("Version ID", 3, 50, false).column("Date", dateLength, dateLength + 10, false).column("Author", 20, 100, true).column("Message", 8, 100, true).build();
        for (int i = 0; i < flowVersionsMetadata.size(); ++i) {
            RegisteredFlowSnapshotMetadata vfs = flowVersionsMetadata.get(i);
            table.addRow("" + (i + 1), vfs.getVersion(), String.format("%1$ta, %<tb %<td %<tY %<tR %<tZ", new Date(vfs.getTimestamp())), vfs.getAuthor() == null ? "" : vfs.getAuthor(), vfs.getComments() == null ? "" : vfs.getComments());
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }
}

