/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.hostdb;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.crawl.NutchWritable;
import org.apache.nutch.hostdb.HostDatum;
import org.apache.nutch.metadata.Nutch;
import org.apache.nutch.net.URLFilters;
import org.apache.nutch.net.URLNormalizers;
import org.apache.nutch.protocol.ProtocolStatus;
import org.apache.nutch.util.URLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateHostDbMapper
extends Mapper<Text, Writable, Text, NutchWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected Text host = new Text();
    protected HostDatum hostDatum = null;
    protected CrawlDatum crawlDatum = null;
    protected String reprUrl = null;
    protected String buffer = null;
    protected String[] args = null;
    protected boolean filter = false;
    protected boolean normalize = false;
    protected boolean readingCrawlDb = false;
    protected URLFilters filters = null;
    protected URLNormalizers normalizers = null;

    public void setup(Mapper.Context context) {
        Configuration conf = context.getConfiguration();
        this.readingCrawlDb = conf.getBoolean("hostdb.reading.crawldb", false);
        this.filter = conf.getBoolean("hostdb.url.filter", false);
        this.normalize = conf.getBoolean("hostdb.url.normalize", false);
        if (this.filter) {
            this.filters = new URLFilters(conf);
        }
        if (this.normalize) {
            this.normalizers = new URLNormalizers(conf, "default");
        }
    }

    protected String filterNormalize(String hostName) {
        if (!this.filter && !this.normalize) {
            return hostName;
        }
        String url = "http://" + hostName + "/";
        Object normalizedUrl = url;
        try {
            if (this.normalize) {
                normalizedUrl = this.normalizers.normalize(url, "default");
            }
            if (this.filter) {
                normalizedUrl = this.filters.filter((String)normalizedUrl);
            }
            if (normalizedUrl == null) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        if (((String)normalizedUrl).equals(url)) {
            return hostName;
        }
        return URLUtil.getHost(url);
    }

    public void map(Text key, Writable value, Mapper.Context context) throws IOException, InterruptedException {
        String keyStr = key.toString();
        if (value instanceof CrawlDatum) {
            URL url;
            try {
                url = new URL(keyStr);
            }
            catch (MalformedURLException e) {
                context.getCounter("UpdateHostDb", "malformed_url").increment(1L);
                return;
            }
            String hostName = URLUtil.getHost(url);
            this.buffer = this.filterNormalize(hostName);
            if (this.buffer == null) {
                context.getCounter("UpdateHostDb", "filtered_records").increment(1L);
                LOG.debug("UpdateHostDb: {} crawldatum has been filtered", (Object)hostName);
                return;
            }
            this.host.set(this.buffer);
            this.crawlDatum = (CrawlDatum)value;
            this.hostDatum = new HostDatum();
            if (this.crawlDatum.getStatus() != 1) {
                String protocol = URLUtil.getProtocol(url);
                if (URLUtil.isHomePageOf(url, this.buffer)) {
                    if (this.crawlDatum.getStatus() == 5 || this.crawlDatum.getStatus() == 4) {
                        ProtocolStatus z = (ProtocolStatus)this.crawlDatum.getMetaData().get((Object)Nutch.WRITABLE_PROTO_STATUS_KEY);
                        this.args = z.getArgs();
                        this.reprUrl = this.args[0];
                        if (this.reprUrl != null) {
                            LOG.debug("UpdateHostDb: homepage: {} redirects to: {}", (Object)keyStr, (Object)this.args[0]);
                            context.write((Object)this.host, (Object)new NutchWritable(this.hostDatum));
                            this.hostDatum.setHomepageUrl(this.reprUrl);
                        } else {
                            LOG.debug("UpdateHostDb: homepage: {} redirects to: {} but has been filtered out", (Object)keyStr, (Object)this.args[0]);
                        }
                    } else {
                        String homepage = protocol + "://" + this.buffer + "/";
                        this.hostDatum.setHomepageUrl(homepage);
                        context.write((Object)this.host, (Object)new NutchWritable(this.hostDatum));
                        LOG.debug("UpdateHostDb: homepage: {}", (Object)homepage);
                    }
                }
            }
            context.write((Object)this.host, (Object)new NutchWritable((Writable)this.crawlDatum));
        } else if (value instanceof HostDatum) {
            this.buffer = this.filterNormalize(keyStr);
            if (this.buffer == null) {
                context.getCounter("UpdateHostDb", "filtered_records").increment(1L);
                LOG.debug("UpdateHostDb: {} hostdatum has been filtered", (Object)keyStr);
                return;
            }
            this.hostDatum = (HostDatum)value;
            key.set(this.buffer);
            if (this.readingCrawlDb) {
                this.hostDatum.resetStatistics();
            }
            context.write((Object)key, (Object)new NutchWritable(this.hostDatum));
        } else if (value instanceof Text) {
            this.buffer = this.filterNormalize(keyStr);
            if (this.buffer == null) {
                context.getCounter("UpdateHostDb", "filtered_records").increment(1L);
                LOG.debug("UpdateHostDb: {} score has been filtered", (Object)keyStr);
                return;
            }
            key.set(this.buffer);
            context.write((Object)key, (Object)new NutchWritable((Writable)new FloatWritable(Float.parseFloat(value.toString()))));
        }
    }
}

