/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.util.geometry;

import com.gargoylesoftware.htmlunit.util.geometry.Point2D;
import com.gargoylesoftware.htmlunit.util.geometry.Shape2D;

public class Line2D
implements Shape2D {
    private final double startX_;
    private final double startY_;
    private final double endX_;
    private final double endY_;
    private final boolean isVertical_;
    private final double slope_;
    private final double yIntercept_;

    public Line2D(Point2D start, Point2D end) {
        this(start.getX(), start.getY(), end.getX(), end.getY());
    }

    public Line2D(double x1, double y1, double x2, double y2) {
        this.startX_ = x1;
        this.startY_ = y1;
        this.endX_ = x2;
        this.endY_ = y2;
        boolean bl = this.isVertical_ = Math.abs(this.startX_ - this.endX_) < 1.0E-7;
        if (this.isVertical_) {
            this.slope_ = Double.NaN;
            this.yIntercept_ = Double.NaN;
        } else {
            this.slope_ = (this.endY_ - this.startY_) / (this.endX_ - this.startX_);
            this.yIntercept_ = this.startY_ - this.slope_ * this.startX_;
        }
    }

    public Point2D intersect(Line2D line) {
        if (this.isVertical_ && line.isVertical_) {
            return null;
        }
        if (this.isVertical_ && !line.isVertical_) {
            double intersectY = line.slope_ * this.startX_ + line.yIntercept_;
            return new Point2D(this.startX_, intersectY);
        }
        if (!this.isVertical_ && line.isVertical_) {
            double intersectY = this.slope_ * line.startX_ + this.yIntercept_;
            return new Point2D(line.startX_, intersectY);
        }
        if (Math.abs(this.slope_ - line.slope_) < 1.0E-7) {
            return null;
        }
        double intersectX = (line.yIntercept_ - this.yIntercept_) / (this.slope_ - line.slope_);
        double intersectY = this.slope_ * intersectX + this.yIntercept_;
        return new Point2D(intersectX, intersectY);
    }

    @Override
    public boolean contains(double x, double y) {
        if (this.isVertical_) {
            if (Math.abs(this.startX_ - x) > 1.0E-7) {
                return false;
            }
        } else {
            double testY = this.slope_ * x + this.yIntercept_;
            if (Math.abs(y - testY) > 1.0E-7) {
                return false;
            }
            if (x < this.startX_ && x < this.endX_ || x > this.startX_ && x > this.endX_) {
                return false;
            }
        }
        return !(y < this.startY_ && y < this.endY_) && (!(y > this.startY_) || !(y > this.endY_));
    }

    @Override
    public boolean isEmpty() {
        return Math.abs(this.startX_ - this.endX_) < 1.0E-7 && Math.abs(this.startY_ - this.endY_) < 1.0E-7;
    }

    public String toString() {
        return "Line2D [ (" + this.startX_ + ", " + this.startY_ + "), (" + this.endX_ + ", " + this.endY_ + "), " + (this.isVertical_ ? "isVertical" : "y = " + this.slope_ + "*x + " + this.yIntercept_ + "]");
    }
}

