/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.sitemaps;

import crawlercommons.filters.basic.BasicURLNormalizer;
import crawlercommons.sitemaps.AbstractSiteMap;
import crawlercommons.sitemaps.SiteMap;
import crawlercommons.sitemaps.SiteMapIndex;
import crawlercommons.sitemaps.SiteMapParser;
import crawlercommons.sitemaps.SiteMapURL;
import crawlercommons.sitemaps.UnknownFormatException;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteMapTester {
    private static final Logger LOG = LoggerFactory.getLogger(SiteMapTester.class);
    private static SiteMapParser saxParser = new SiteMapParser(false, true);

    public static void main(String[] args) throws IOException, UnknownFormatException {
        if (args.length < 1) {
            LOG.error("Fetch and process a sitemap (recursively if a sitemap index)");
            LOG.error("Usage: SiteMapTester <URL_TO_TEST> [MIME_TYPE]");
            LOG.error("Options:");
            LOG.error("  URL_TO_TEST  URL of sitemap");
            LOG.error("  MIME_TYPE    force processing sitemap as MIME type,");
            LOG.error("               bypass automatic MIME type detection");
            LOG.error("Java properties:");
            LOG.error("  sitemap.strictNamespace");
            LOG.error("                  if true sitemaps are required to use the standard namespace URI");
            LOG.error("  sitemap.allow.dtd");
            LOG.error("                  if true sitemaps are allowed to include a DTD");
            LOG.error("  sitemap.extensions");
            LOG.error("                  if true enable sitemap extension parsing");
            LOG.error("  sitemap.filter.urls");
            LOG.error("                  if true filter and normalize all URLs found in the sitemap");
            LOG.error("                  using crawlercommons.filters.basic.BasicURLNormalizer");
        } else {
            URL url = new URL(args[0]);
            String mt = args.length > 1 ? args[1] : null;
            SiteMapTester.parse(url, mt);
        }
    }

    private static void parse(URL url, String mt) throws IOException, UnknownFormatException {
        boolean enableURLFilter;
        byte[] content = IOUtils.toByteArray((URL)url);
        LOG.info("Parsing {} {}", (Object)url, mt != null && !mt.isEmpty() ? "as MIME type " + mt : "");
        boolean strictNamespace = Boolean.getBoolean("sitemap.strictNamespace");
        saxParser.setStrictNamespace(strictNamespace);
        boolean allowDTD = Boolean.getBoolean("sitemap.allow.dtd");
        saxParser.setAllowDocTypeDefinitions(allowDTD);
        boolean enableExtensions = Boolean.getBoolean("sitemap.extensions");
        if (enableExtensions) {
            saxParser.enableExtensions();
        }
        if (enableURLFilter = Boolean.getBoolean("sitemap.filter.urls")) {
            saxParser.setURLFilter(new BasicURLNormalizer());
        }
        AbstractSiteMap sm = null;
        sm = mt == null || mt.equals("") ? saxParser.parseSiteMap(content, url) : saxParser.parseSiteMap(mt, content, url);
        if (sm.isIndex()) {
            Collection<AbstractSiteMap> links = ((SiteMapIndex)sm).getSitemaps();
            for (AbstractSiteMap asm : links) {
                SiteMapTester.parse(asm.getUrl(), mt);
            }
        } else {
            Collection<SiteMapURL> links = ((SiteMap)sm).getSiteMapUrls();
            for (SiteMapURL smu : links) {
                if (enableExtensions) {
                    LOG.info(smu.toString());
                    continue;
                }
                LOG.info(smu.getUrl().toString());
            }
        }
    }
}

