/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.http;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Logger;
import org.archive.format.http.HttpHeader;
import org.archive.format.http.HttpHeaderObserver;
import org.archive.util.ByteOp;
import org.archive.util.DateUtils;

public class HttpHeaders
extends ArrayList<HttpHeader>
implements HttpHeaderObserver {
    private static final Logger LOG = Logger.getLogger(HttpHeaders.class.getName());
    private static final long serialVersionUID = 5737284156382429120L;
    private boolean isCorrupt = false;
    private int totalBytes;

    public void setDateHeader(String name, long ms) {
        this.setDateHeader(name, new Date(ms));
    }

    public void setDateHeader(String name, Date d) {
        String dv = DateUtils.getRFC1123Date(d);
        this.set(name, dv);
    }

    public void addDateHeader(String name, long ms) {
        this.addDateHeader(name, new Date(ms));
    }

    public void addDateHeader(String name, Date d) {
        String dv = DateUtils.getRFC1123Date(d);
        this.add(name, dv);
    }

    public HttpHeader get(String name) {
        for (HttpHeader h : this) {
            if (!h.getName().equals(name)) continue;
            return h;
        }
        return null;
    }

    public String getValue(String name) {
        HttpHeader header = this.get(name);
        return header == null ? null : header.getValue();
    }

    public String getValueCaseInsensitive(String name) {
        String lc = name.toLowerCase();
        for (HttpHeader h : this) {
            if (!h.getName().toLowerCase().equals(lc)) continue;
            return h.getValue();
        }
        return null;
    }

    public long getContentLength() {
        String val = this.getValueCaseInsensitive("content-length");
        if (val != null) {
            try {
                return Long.parseLong(val);
            }
            catch (NumberFormatException e) {
                LOG.warning(e.getMessage());
            }
        }
        return -1L;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HttpHeaders:\n==========\n");
        for (HttpHeader header : this) {
            sb.append("\t").append(header.toString()).append("\n");
        }
        sb.append("========\n");
        return sb.toString();
    }

    @Override
    public void headerParsed(byte[] name, int ns, int nl, byte[] value, int vs, int vl) {
        String sName = new String(ByteOp.copy(name, 0, nl), UTF8);
        String sValue = new String(ByteOp.copy(value, 0, vl), UTF8);
        this.add(new HttpHeader(sName, sValue));
    }

    @Override
    public void headersComplete(int bytesRead) {
        this.totalBytes = bytesRead;
    }

    @Override
    public void headersCorrupt() {
        this.isCorrupt = true;
    }

    public boolean isCorrupt() {
        return this.isCorrupt;
    }

    public int getTotalBytes() {
        return this.totalBytes;
    }

    public void set(String name, String value) {
        HttpHeader header = this.get(name);
        if (header == null) {
            this.add(name, value);
        } else {
            header.setValue(value);
        }
    }

    public void add(String name, String value) {
        this.add(new HttpHeader(name, value));
    }

    public void write(OutputStream out) throws IOException {
        for (HttpHeader header : this) {
            header.write(out);
        }
        out.write(13);
        out.write(10);
    }
}

