/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.json;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.archive.format.json.JSONPathSpec;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SimpleJSONPathSpec
implements JSONPathSpec {
    private static final Logger LOG = Logger.getLogger(SimpleJSONPathSpec.class.getName());
    private String[] parts;
    private List<String> emptyResult;
    private static final List<String> EMPTY_MATCH = new ArrayList<String>();

    public SimpleJSONPathSpec(String pathSpec) {
        this.parts = pathSpec.split("\\.");
        this.emptyResult = this.calculateEmptyResult(this.parts[this.parts.length - 1]);
    }

    private List<String> calculateEmptyResult(String last) {
        ArrayList<String> empty = new ArrayList<String>();
        if (last.startsWith("{") && last.endsWith("}")) {
            String inner = last.substring(1, last.length() - 1);
            String[] subParts = inner.split(",");
            for (int i = 0; i < subParts.length; ++i) {
                empty.add("");
            }
        } else {
            empty.add("");
        }
        return empty;
    }

    @Override
    public List<List<String>> extract(JSONObject json) {
        ArrayList<List<String>> matches = new ArrayList<List<String>>();
        try {
            this.extractRecursive(json, this.parts, 0, matches);
        }
        catch (JSONException e) {
            LOG.warning(e.getMessage());
        }
        return matches;
    }

    private void extractRecursive(JSONObject json, String[] path, int idx, List<List<String>> matches) throws JSONException {
        if (json == null) {
            return;
        }
        String part = path[idx];
        if (idx == path.length - 1) {
            List<String> match = this.applyMatch(json, part);
            matches.add(match);
        } else if (part.startsWith("@")) {
            if (json.has(part = part.substring(1))) {
                JSONArray a = json.getJSONArray(part);
                for (int i = 0; i < a.length(); ++i) {
                    this.extractRecursive(a.getJSONObject(i), path, idx + 1, matches);
                }
            } else {
                matches.add(this.emptyResult);
            }
        } else if (json.has(part)) {
            this.extractRecursive(json.getJSONObject(part), path, idx + 1, matches);
        } else {
            matches.add(this.emptyResult);
        }
    }

    private List<String> applyMatch(JSONObject json, String part) throws JSONException {
        ArrayList<String> match = new ArrayList<String>();
        if (part.startsWith("{") && part.endsWith("}")) {
            String[] subParts;
            String inner = part.substring(1, part.length() - 1);
            for (String subPart : subParts = inner.split(",")) {
                if (json.has(subPart)) {
                    match.add(json.get(subPart).toString());
                    continue;
                }
                match.add("");
            }
        } else if (json.has(part)) {
            match.add(json.get(part).toString());
        } else {
            return this.emptyResult;
        }
        return match;
    }

    static {
        EMPTY_MATCH.add("");
    }
}

