/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.FullQualifiedName;

public class ActionMapKey {
    private final FullQualifiedName actionName;
    private final FullQualifiedName bindingParameterTypeName;
    private final Boolean isBindingParameterCollection;

    public ActionMapKey(FullQualifiedName actionName, FullQualifiedName bindingParameterTypeName, Boolean isBindingParameterCollection) {
        if (actionName == null || bindingParameterTypeName == null || isBindingParameterCollection == null) {
            throw new EdmException("Action name, binding parameter type and binding parameter collection must not be null for bound actions");
        }
        this.actionName = actionName;
        this.bindingParameterTypeName = bindingParameterTypeName;
        this.isBindingParameterCollection = isBindingParameterCollection;
    }

    public int hashCode() {
        String forHash = this.actionName.toString() + this.bindingParameterTypeName.toString() + this.isBindingParameterCollection.toString();
        return forHash.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ActionMapKey)) {
            return false;
        }
        ActionMapKey other = (ActionMapKey)obj;
        return this.actionName.equals(other.actionName) && this.bindingParameterTypeName.equals(other.bindingParameterTypeName) && this.isBindingParameterCollection.equals(other.isBindingParameterCollection);
    }
}

