/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.commons;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.olingo.client.api.uri.URIBuilder;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.ext.proxy.AbstractService;
import org.apache.olingo.ext.proxy.api.AbstractEntitySet;
import org.apache.olingo.ext.proxy.api.AbstractSingleton;
import org.apache.olingo.ext.proxy.api.EntityCollection;
import org.apache.olingo.ext.proxy.api.EntityType;
import org.apache.olingo.ext.proxy.api.Search;
import org.apache.olingo.ext.proxy.commons.AbstractEntityCollectionInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntityCollectionInvocationHandler;
import org.apache.olingo.ext.proxy.utils.ClassUtils;

public class InlineEntitySetInvocationHandler<T extends EntityType<?>, KEY extends Serializable, EC extends EntityCollection<T, ?, ?>>
extends AbstractEntityCollectionInvocationHandler<T, EC>
implements AbstractEntitySet<T, KEY, EC> {
    private static final long serialVersionUID = 2629912294765040027L;

    public static InlineEntitySetInvocationHandler getInstance(Class<?> ref, AbstractService<?> service, URI uri, List<Object> items) {
        return new InlineEntitySetInvocationHandler(ref, service, service.getClient().newURIBuilder(uri.toASCIIString()), items);
    }

    protected InlineEntitySetInvocationHandler(Class<?> ref, AbstractService<?> service, URIBuilder uri, Collection<T> items) {
        super(ref, service, uri);
        this.items = items;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("filter".equals(method.getName()) || "orderBy".equals(method.getName()) || "top".equals(method.getName()) || "skip".equals(method.getName()) || "expand".equals(method.getName()) || "select".equals(method.getName())) {
            this.invokeSelfMethod(method, args);
            return proxy;
        }
        if (this.isSelfMethod(method)) {
            return this.invokeSelfMethod(method, args);
        }
        throw new NoSuchMethodException(method.getName());
    }

    @Override
    public Long count() {
        return this.size();
    }

    @Override
    public Boolean exists(KEY key) throws IllegalArgumentException {
        throw new UnsupportedOperationException("exists not supported on inline entity set");
    }

    @Override
    public T getByKey(KEY key) throws IllegalArgumentException {
        return (T)this.getByKey(key, this.itemRef);
    }

    @Override
    public <S extends T> S getByKey(KEY key, Class<S> typeRef) throws IllegalArgumentException {
        throw new UnsupportedOperationException("getByKey not supported on inline entity set");
    }

    public EC execute() {
        return (EC)this.execute(this.collItemRef);
    }

    public <S extends T, SEC extends EntityCollection<S, ?, ?>> Future<SEC> executeAsync(final Class<SEC> collTypeRef) {
        return this.service.getClient().getConfiguration().getExecutor().submit(new Callable<SEC>(){

            @Override
            public SEC call() throws Exception {
                return InlineEntitySetInvocationHandler.this.execute(collTypeRef);
            }
        });
    }

    public <S extends T, SEC extends EntityCollection<S, ?, ?>> SEC execute(Class<SEC> collTypeRef) {
        Class<?> ref = ClassUtils.extractTypeArg(collTypeRef, AbstractEntitySet.class, AbstractSingleton.class, EntityCollection.class);
        Class<?> oref = ClassUtils.extractTypeArg(this.collItemRef, AbstractEntitySet.class, AbstractSingleton.class, EntityCollection.class);
        if (!oref.equals(ref)) {
            this.uri.appendDerivedEntityTypeSegment(new FullQualifiedName(ClassUtils.getNamespace(ref), ClassUtils.getEntityTypeName(ref)).toString());
        }
        EntityCollectionInvocationHandler entityCollectionHandler = new EntityCollectionInvocationHandler(this.service, this.items, collTypeRef, this.baseURI, this.uri);
        return (SEC)((EntityCollection)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{collTypeRef}, entityCollectionHandler));
    }

    @Override
    public Search<T, EC> createSearch() {
        throw new UnsupportedOperationException("Search not supported on inline entity set");
    }

    @Override
    public <S extends T, SEC extends EntityCollection<S, ?, ?>> Search<S, SEC> createSearch(Class<SEC> reference) {
        throw new UnsupportedOperationException("Search not supported on inline entity set");
    }

    @Override
    public void delete(KEY key) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Delete not supported on inline entity set");
    }

    @Override
    public <S extends T> void delete(S entity) {
        throw new UnsupportedOperationException("Delete not supported on inline entity set");
    }

    @Override
    public <S extends T> void delete(Iterable<S> entities) {
        throw new UnsupportedOperationException("Delete not supported on inline entity set");
    }
}

