/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordReaderWriter;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryMetadata;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryMetadataImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;

public final class Records {
    private Records() {
    }

    public static void writeRecord(ObjectDataOutput out, Record record, Data dataValue) throws IOException {
        RecordReaderWriter readerWriter = record.getMatchingRecordReaderWriter();
        out.writeByte(readerWriter.getId());
        readerWriter.writeRecord(out, record, dataValue);
    }

    public static Record readRecord(ObjectDataInput in) throws IOException {
        byte matchingDataRecordId = in.readByte();
        return RecordReaderWriter.getById(matchingDataRecordId).readRecord(in);
    }

    public static void writeExpiry(ObjectDataOutput out, ExpiryMetadata expiryMetadata) throws IOException {
        boolean hasExpiry = expiryMetadata.hasExpiry();
        out.writeBoolean(hasExpiry);
        if (hasExpiry) {
            expiryMetadata.write(out);
        }
    }

    public static ExpiryMetadata readExpiry(ObjectDataInput in) throws IOException {
        ExpiryMetadata expiryMetadata = ExpiryMetadata.NULL;
        boolean hasExpiry = in.readBoolean();
        if (hasExpiry) {
            expiryMetadata = new ExpiryMetadataImpl();
            expiryMetadata.read(in);
        }
        return expiryMetadata;
    }

    public static void copyMetadataFrom(Record fromRecord, Record toRecord) {
        if (fromRecord == null) {
            return;
        }
        toRecord.setHits(fromRecord.getHits());
        toRecord.setVersion(fromRecord.getVersion());
        toRecord.setCreationTime(fromRecord.getCreationTime());
        toRecord.setLastAccessTime(fromRecord.getLastAccessTime());
        toRecord.setLastStoredTime(fromRecord.getLastStoredTime());
        toRecord.setLastUpdateTime(fromRecord.getLastUpdateTime());
    }

    public static Object getCachedValue(Record record) {
        Object cachedValue;
        do {
            if ((cachedValue = record.getCachedValueUnsafe()) instanceof Thread) continue;
            return cachedValue;
        } while ((cachedValue = ThreadWrapper.unwrapOrNull(cachedValue)) == null);
        return cachedValue;
    }

    public static Object getValueOrCachedValue(Record record, SerializationService serializationService) {
        Object cachedValue = record.getCachedValueUnsafe();
        if (cachedValue == Record.NOT_CACHED) {
            return record.getValue();
        }
        while (true) {
            if (cachedValue == null) {
                Object valueBeforeCas = record.getValue();
                if (!Records.shouldCache(valueBeforeCas)) {
                    return valueBeforeCas;
                }
                Object fromCache = Records.tryStoreIntoCache(record, valueBeforeCas, serializationService);
                if (fromCache != null) {
                    return fromCache;
                }
            } else if (cachedValue instanceof Thread) {
                if ((cachedValue = ThreadWrapper.unwrapOrNull(cachedValue)) != null) {
                    return cachedValue;
                }
            } else {
                return cachedValue;
            }
            Thread.yield();
            cachedValue = record.getCachedValueUnsafe();
        }
    }

    private static Object tryStoreIntoCache(Record record, Object valueBeforeCas, SerializationService serializationService) {
        Thread currentThread = Thread.currentThread();
        if (!record.casCachedValue(null, currentThread)) {
            return null;
        }
        Object valueAfterCas = record.getValue();
        Object object = null;
        try {
            object = serializationService.toObject(valueBeforeCas);
        }
        catch (Exception e) {
            record.casCachedValue(currentThread, null);
            throw e;
        }
        if (valueAfterCas == valueBeforeCas) {
            Object wrappedObject = ThreadWrapper.wrapIfNeeded(object);
            record.casCachedValue(currentThread, wrappedObject);
        } else {
            record.casCachedValue(currentThread, null);
        }
        return object;
    }

    static boolean shouldCache(Object value) {
        if (value instanceof Data) {
            Data data = (Data)value;
            return !data.isPortable() && !data.isJson() && !data.isCompact();
        }
        return false;
    }

    private static final class ThreadWrapper
    extends Thread {
        private final Thread wrappedValue;

        private ThreadWrapper(Thread wrappedValue) {
            this.wrappedValue = wrappedValue;
        }

        static Object unwrapOrNull(Object o) {
            if (o instanceof ThreadWrapper) {
                ThreadWrapper wrapper = (ThreadWrapper)o;
                return wrapper.wrappedValue;
            }
            return null;
        }

        static Object wrapIfNeeded(Object object) {
            if (object instanceof Thread) {
                Thread thread = (Thread)object;
                return new ThreadWrapper(thread);
            }
            return object;
        }
    }
}

