/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.scripting;

import java.io.PrintWriter;
import java.io.Reader;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.LazyBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.api.wrappers.JakartaToJavaxRequestWrapper;
import org.apache.sling.api.wrappers.JakartaToJavaxResponseWrapper;
import org.apache.sling.api.wrappers.JavaxToJakartaRequestWrapper;
import org.apache.sling.api.wrappers.JavaxToJakartaResponseWrapper;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class SlingBindings
extends LazyBindings {
    private static final long serialVersionUID = 209505693646323450L;
    public static final String JAKARTA_REQUEST = "jakartaRequest";
    public static final String JAKARTA_RESPONSE = "jakartaResponse";
    @Deprecated
    public static final String REQUEST = "request";
    @Deprecated
    public static final String RESPONSE = "response";
    public static final String READER = "reader";
    public static final String SLING = "sling";
    public static final String RESOURCE = "resource";
    public static final String RESOLVER = "resolver";
    public static final String OUT = "out";
    public static final String FLUSH = "flush";
    public static final String LOG = "log";

    protected <ObjectType> ObjectType get(String key, Class<ObjectType> type) {
        Object o = this.get(key);
        if (type.isInstance(o)) {
            return (ObjectType)o;
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        Object result = super.put(key, value);
        if (REQUEST.equals(key)) {
            if (value instanceof SlingHttpServletRequest) {
                super.put(JAKARTA_REQUEST, (Object)JavaxToJakartaRequestWrapper.toJakartaRequest(this.getRequest()));
            }
        } else if (JAKARTA_REQUEST.equals(key)) {
            if (value instanceof SlingJakartaHttpServletRequest) {
                super.put(REQUEST, (Object)JakartaToJavaxRequestWrapper.toJavaxRequest(this.getJakartaRequest()));
            }
        } else if (RESPONSE.equals(key)) {
            if (value instanceof SlingHttpServletResponse) {
                super.put(JAKARTA_RESPONSE, (Object)JavaxToJakartaResponseWrapper.toJakartaResponse(this.getResponse()));
            }
        } else if (JAKARTA_RESPONSE.equals(key) && value instanceof SlingJakartaHttpServletResponse) {
            super.put(RESPONSE, (Object)JakartaToJavaxResponseWrapper.toJavaxResponse(this.getJakartaResponse()));
        }
        return result;
    }

    @Override
    public Object remove(Object key) {
        if (REQUEST.equals(key)) {
            super.remove(JAKARTA_REQUEST);
        } else if (JAKARTA_REQUEST.equals(key)) {
            super.remove(REQUEST);
        } else if (RESPONSE.equals(key)) {
            super.remove(JAKARTA_RESPONSE);
        } else if (JAKARTA_RESPONSE.equals(key)) {
            super.remove(RESPONSE);
        }
        return super.remove(key);
    }

    protected void safePut(String key, Object value) {
        if (value != null) {
            this.put(key, value);
        }
    }

    public void setFlush(boolean flush) {
        this.put(FLUSH, (Object)flush);
    }

    public boolean getFlush() {
        Boolean value = this.get(FLUSH, Boolean.class);
        if (value != null) {
            return value;
        }
        return false;
    }

    public void setLog(Logger log) {
        this.safePut(LOG, log);
    }

    @Nullable
    public Logger getLog() {
        return this.get(LOG, Logger.class);
    }

    public void setOut(PrintWriter out) {
        this.safePut(OUT, out);
    }

    @Nullable
    public PrintWriter getOut() {
        return this.get(OUT, PrintWriter.class);
    }

    public void setJakartaRequest(SlingJakartaHttpServletRequest request) {
        this.safePut(JAKARTA_REQUEST, request);
    }

    @Nullable
    public SlingJakartaHttpServletRequest getJakartaRequest() {
        return this.get(JAKARTA_REQUEST, SlingJakartaHttpServletRequest.class);
    }

    @Deprecated
    public void setRequest(SlingHttpServletRequest request) {
        this.safePut(REQUEST, request);
    }

    @Deprecated
    @Nullable
    public SlingHttpServletRequest getRequest() {
        return this.get(REQUEST, SlingHttpServletRequest.class);
    }

    public void setReader(Reader reader) {
        this.safePut(READER, reader);
    }

    @Nullable
    public Reader getReader() {
        return this.get(READER, Reader.class);
    }

    public void setResource(Resource resource) {
        this.safePut(RESOURCE, resource);
    }

    @Nullable
    public Resource getResource() {
        return this.get(RESOURCE, Resource.class);
    }

    public void setResourceResolver(ResourceResolver resourceResolver) {
        this.safePut(RESOLVER, resourceResolver);
    }

    @Nullable
    public ResourceResolver getResourceResolver() {
        return this.get(RESOLVER, ResourceResolver.class);
    }

    public void setJakartaResponse(SlingJakartaHttpServletResponse response) {
        this.safePut(JAKARTA_RESPONSE, response);
    }

    @Nullable
    public SlingJakartaHttpServletResponse getJakartaResponse() {
        return this.get(JAKARTA_RESPONSE, SlingJakartaHttpServletResponse.class);
    }

    @Deprecated
    public void setResponse(SlingHttpServletResponse response) {
        this.safePut(RESPONSE, response);
    }

    @Deprecated
    @Nullable
    public SlingHttpServletResponse getResponse() {
        return this.get(RESPONSE, SlingHttpServletResponse.class);
    }

    public void setSling(SlingScriptHelper sling) {
        this.safePut(SLING, sling);
    }

    @Nullable
    public SlingScriptHelper getSling() {
        return this.get(SLING, SlingScriptHelper.class);
    }
}

