/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client.impl;

import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.token.Tokens;
import com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import org.apache.sling.auth.oauth_client.impl.OAuthTokens;
import org.apache.sling.auth.oauth_client.impl.OidcTokens;
import org.jetbrains.annotations.NotNull;

public class Converter {
    @NotNull
    public static OIDCTokens toNimbusOidcTokens(@NotNull OidcTokens tokens) {
        RefreshToken nimbusRefreshToken = tokens.refreshToken() != null ? new RefreshToken(tokens.refreshToken()) : null;
        BearerAccessToken nimbusAccessToken = new BearerAccessToken(tokens.accessToken(), tokens.expiresAt(), null);
        OIDCTokens nimbusTokens = tokens.idToken() != null ? new OIDCTokens(tokens.idToken(), (AccessToken)nimbusAccessToken, nimbusRefreshToken) : new OIDCTokens((AccessToken)nimbusAccessToken, nimbusRefreshToken);
        return nimbusTokens;
    }

    @NotNull
    public static OidcTokens toApiOidcTokens(@NotNull OIDCTokens nimbusTokens) {
        String accessToken = nimbusTokens.getAccessToken() != null ? nimbusTokens.getAccessToken().getValue() : null;
        long expiresAt = nimbusTokens.getAccessToken() != null ? nimbusTokens.getAccessToken().getLifetime() : 0L;
        String refreshToken = nimbusTokens.getRefreshToken() != null ? nimbusTokens.getRefreshToken().getValue() : null;
        String idToken = nimbusTokens.getIDTokenString();
        return new OidcTokens(accessToken, expiresAt, refreshToken, idToken);
    }

    @NotNull
    public static OAuthTokens toSlingOAuthTokens(@NotNull OIDCTokens nimbusTokens) {
        String accessToken = nimbusTokens.getAccessToken() != null ? nimbusTokens.getAccessToken().getValue() : null;
        long expiresAt = nimbusTokens.getAccessToken() != null ? nimbusTokens.getAccessToken().getLifetime() : 0L;
        String refreshToken = nimbusTokens.getRefreshToken() != null ? nimbusTokens.getRefreshToken().getValue() : null;
        return new OAuthTokens(accessToken, expiresAt, refreshToken);
    }

    @NotNull
    public static OAuthTokens toSlingOAuthTokens(@NotNull Tokens oAuthTokens) {
        String accessToken = oAuthTokens.getAccessToken() != null ? oAuthTokens.getAccessToken().getValue() : null;
        long expiresAt = oAuthTokens.getAccessToken() != null ? oAuthTokens.getAccessToken().getLifetime() : 0L;
        String refreshToken = oAuthTokens.getRefreshToken() != null ? oAuthTokens.getRefreshToken().getValue() : null;
        return new OAuthTokens(accessToken, expiresAt, refreshToken);
    }

    private Converter() {
    }
}

