/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl;

import org.apache.sling.installer.api.event.InstallationEvent;
import org.apache.sling.installer.api.event.InstallationListener;
import org.apache.sling.installer.api.tasks.TaskResource;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;

public class InstallListener
implements InstallationListener {
    private static final InstallationEvent START_EVENT = new InstallationEvent(){

        @Override
        public InstallationEvent.TYPE getType() {
            return InstallationEvent.TYPE.STARTED;
        }

        @Override
        public Object getSource() {
            return null;
        }
    };
    private static final InstallationEvent SUSPENDED_EVENT = new InstallationEvent(){

        @Override
        public InstallationEvent.TYPE getType() {
            return InstallationEvent.TYPE.SUSPENDED;
        }

        @Override
        public Object getSource() {
            return null;
        }
    };
    private final ServiceTracker tracker;
    private volatile boolean started = false;
    private final Logger logger;

    public InstallListener(BundleContext context, Logger logger) {
        this.logger = logger;
        this.tracker = new ServiceTracker(context, InstallationListener.class.getName(), null);
        this.tracker.open();
    }

    public void dispose() {
        this.tracker.close();
    }

    @Override
    public void onEvent(InstallationEvent event) {
        Object[] listeners;
        if (this.logger.isDebugEnabled()) {
            if (event.getType() == InstallationEvent.TYPE.STARTED) {
                this.logger.debug("onEvent(STARTED).");
            } else if (event.getType() == InstallationEvent.TYPE.SUSPENDED) {
                this.logger.debug("onEvent(SUSPENDED).");
            } else {
                TaskResource src = (TaskResource)event.getSource();
                this.logger.debug("onEvent(event.getSource(): {})", (Object)src);
            }
        }
        if ((listeners = this.tracker.getServices()) != null) {
            for (Object l : listeners) {
                if (!(l instanceof InstallationListener)) continue;
                ((InstallationListener)l).onEvent(event);
            }
        }
    }

    public synchronized void start() {
        if (!this.started) {
            this.logger.debug("Starting new installer cycle");
            this.started = true;
            this.onEvent(START_EVENT);
        }
    }

    public synchronized void suspend() {
        if (this.started) {
            this.started = false;
            this.onEvent(SUSPENDED_EVENT);
        }
    }
}

